/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.admin.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.dubbo.admin.model.domain.Consumer;
import org.apache.dubbo.admin.model.dto.RelationDTO;
import org.apache.dubbo.admin.service.ConsumerService;
import org.apache.dubbo.admin.service.MetricsService;
import org.apache.dubbo.admin.service.ProviderService;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MetricsServiceImpl
implements MetricsService {
    @Autowired
    private ConsumerService consumerService;
    @Autowired
    private ProviderService providerService;

    public RelationDTO getApplicationRelation() {
        List consumerList = this.consumerService.findAll();
        List providerList = this.providerService.findAll();
        int index = 0;
        HashSet<String> serviceSet = new HashSet<String>();
        HashMap<Object, RelationDTO.Node> consumerNodeMap = new HashMap<Object, RelationDTO.Node>();
        HashMap<String, Set> consumerServiceApplicationMap = new HashMap<String, Set>();
        for (Consumer consumer : consumerList) {
            String application = consumer.getApplication();
            if (!consumerNodeMap.keySet().contains(application)) {
                RelationDTO.Node node = new RelationDTO.Node(Integer.valueOf(index), application, RelationDTO.CONSUMER_CATEGORIES.getIndex().intValue());
                consumerNodeMap.put(application, node);
                ++index;
            }
            String service = consumer.getService();
            serviceSet.add(service);
            consumerServiceApplicationMap.computeIfAbsent(service, s -> new HashSet());
            ((Set)consumerServiceApplicationMap.get(service)).add(application);
        }
        HashMap<String, RelationDTO.Node> providerNodeMap = new HashMap<String, RelationDTO.Node>();
        HashMap<String, Set> providerServiceApplicationMap = new HashMap<String, Set>();
        for (Object provider : providerList) {
            String string = provider.getApplication();
            if (!providerNodeMap.keySet().contains(string)) {
                RelationDTO.Node node = new RelationDTO.Node(Integer.valueOf(index), string, RelationDTO.PROVIDER_CATEGORIES.getIndex().intValue());
                providerNodeMap.put(string, node);
                ++index;
            }
            String service = provider.getService();
            serviceSet.add(service);
            providerServiceApplicationMap.computeIfAbsent(service, s -> new HashSet());
            ((Set)providerServiceApplicationMap.get(service)).add(string);
        }
        HashMap nodeMap = new HashMap(consumerNodeMap);
        for (Map.Entry entry : providerNodeMap.entrySet()) {
            if (nodeMap.get(entry.getKey()) != null) {
                ((RelationDTO.Node)nodeMap.get(entry.getKey())).setCategory(RelationDTO.CONSUMER_AND_PROVIDER_CATEGORIES.getIndex().intValue());
                continue;
            }
            nodeMap.put(entry.getKey(), entry.getValue());
        }
        HashSet<RelationDTO.Link> linkSet = new HashSet<RelationDTO.Link>();
        for (String service : serviceSet) {
            Set consumerApplicationSet = (Set)consumerServiceApplicationMap.get(service);
            Set providerApplicationSet = (Set)providerServiceApplicationMap.get(service);
            if (!CollectionUtils.isNotEmpty((Collection)consumerApplicationSet) || !CollectionUtils.isNotEmpty((Collection)providerApplicationSet)) continue;
            for (String providerApplication : providerApplicationSet) {
                for (String consumerApplication : consumerApplicationSet) {
                    if (nodeMap.get(consumerApplication) == null || nodeMap.get(providerApplication) == null) continue;
                    Integer consumerIndex = ((RelationDTO.Node)nodeMap.get(consumerApplication)).getIndex();
                    Integer providerIndex = ((RelationDTO.Node)nodeMap.get(providerApplication)).getIndex();
                    linkSet.add(new RelationDTO.Link(consumerIndex.intValue(), providerIndex.intValue()));
                }
            }
        }
        List list = nodeMap.values().stream().sorted(Comparator.comparingInt(RelationDTO.Node::getIndex)).collect(Collectors.toList());
        return new RelationDTO(list, new ArrayList(linkSet));
    }
}

