/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.admin.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.admin.common.util.Constants;
import org.apache.dubbo.admin.common.util.ConvertUtil;
import org.apache.dubbo.admin.common.util.OverrideUtils;
import org.apache.dubbo.admin.common.util.YamlParser;
import org.apache.dubbo.admin.model.adapter.DynamicConfigDTO2OverrideDTOAdapter;
import org.apache.dubbo.admin.model.adapter.LoadBalance2OverrideAdapter;
import org.apache.dubbo.admin.model.adapter.WeightToOverrideAdapter;
import org.apache.dubbo.admin.model.domain.LoadBalance;
import org.apache.dubbo.admin.model.domain.Override;
import org.apache.dubbo.admin.model.domain.Weight;
import org.apache.dubbo.admin.model.dto.BalancingDTO;
import org.apache.dubbo.admin.model.dto.BaseDTO;
import org.apache.dubbo.admin.model.dto.DynamicConfigDTO;
import org.apache.dubbo.admin.model.dto.WeightDTO;
import org.apache.dubbo.admin.model.store.OverrideConfig;
import org.apache.dubbo.admin.model.store.OverrideDTO;
import org.apache.dubbo.admin.service.OverrideService;
import org.apache.dubbo.admin.service.impl.AbstractService;
import org.springframework.stereotype.Component;

@Component
public class OverrideServiceImpl
extends AbstractService
implements OverrideService {
    private String prefix = "config/dubbo";

    public void saveOverride(DynamicConfigDTO override) {
        String id = ConvertUtil.getIdFromDTO((BaseDTO)override);
        String path = this.getPath(id);
        String exitConfig = this.dynamicConfiguration.getConfig(path);
        ArrayList<OverrideConfig> configs = new ArrayList<OverrideConfig>();
        DynamicConfigDTO2OverrideDTOAdapter existOverride = new DynamicConfigDTO2OverrideDTOAdapter(override);
        if (exitConfig != null && (existOverride = (OverrideDTO)YamlParser.loadObject((String)exitConfig, OverrideDTO.class)).getConfigs() != null) {
            for (OverrideConfig overrideConfig : existOverride.getConfigs()) {
                if (!Constants.CONFIGS.contains(overrideConfig.getType())) continue;
                configs.add(overrideConfig);
            }
        }
        configs.addAll(override.getConfigs());
        existOverride.setEnabled(override.isEnabled());
        existOverride.setConfigs(configs);
        this.dynamicConfiguration.setConfig(path, YamlParser.dumpObject((Object)existOverride));
        if (StringUtils.isNotEmpty((CharSequence)override.getService())) {
            List result = this.convertDTOtoOldOverride(override);
            for (Override o : result) {
                this.registry.register(o.toUrl().addParameter("compatible_config", true));
            }
        }
    }

    public void updateOverride(DynamicConfigDTO update) {
        String id = ConvertUtil.getIdFromDTO((BaseDTO)update);
        String path = this.getPath(id);
        String exitConfig = this.dynamicConfiguration.getConfig(path);
        if (exitConfig == null) {
            // empty if block
        }
        OverrideDTO overrideDTO = (OverrideDTO)YamlParser.loadObject((String)exitConfig, OverrideDTO.class);
        DynamicConfigDTO old = OverrideUtils.createFromOverride((OverrideDTO)overrideDTO);
        ArrayList<OverrideConfig> configs = new ArrayList<OverrideConfig>();
        if (overrideDTO.getConfigs() != null) {
            List overrideConfigs = overrideDTO.getConfigs();
            for (OverrideConfig config : overrideConfigs) {
                if (!Constants.CONFIGS.contains(config.getType())) continue;
                configs.add(config);
            }
        }
        configs.addAll(update.getConfigs());
        overrideDTO.setConfigs(configs);
        overrideDTO.setEnabled(update.isEnabled());
        this.dynamicConfiguration.setConfig(path, YamlParser.dumpObject((Object)overrideDTO));
        if (StringUtils.isNotEmpty((CharSequence)update.getService())) {
            List oldOverrides = this.convertDTOtoOldOverride(old);
            List updatedOverrides = this.convertDTOtoOldOverride(update);
            for (Override o : oldOverrides) {
                this.registry.unregister(o.toUrl().addParameter("compatible_config", true));
            }
            for (Override o : updatedOverrides) {
                this.registry.register(o.toUrl().addParameter("compatible_config", true));
            }
        }
    }

    public void deleteOverride(String id) {
        String path;
        String config;
        if (StringUtils.isEmpty((CharSequence)id)) {
            // empty if block
        }
        if ((config = this.dynamicConfiguration.getConfig(path = this.getPath(id))) == null) {
            // empty if block
        }
        OverrideDTO overrideDTO = (OverrideDTO)YamlParser.loadObject((String)config, OverrideDTO.class);
        DynamicConfigDTO old = OverrideUtils.createFromOverride((OverrideDTO)overrideDTO);
        ArrayList<OverrideConfig> newConfigs = new ArrayList<OverrideConfig>();
        if (overrideDTO.getConfigs() != null && overrideDTO.getConfigs().size() > 0) {
            for (OverrideConfig overrideConfig : overrideDTO.getConfigs()) {
                if (!Constants.CONFIGS.contains(overrideConfig.getType())) continue;
                newConfigs.add(overrideConfig);
            }
            if (newConfigs.size() == 0) {
                this.dynamicConfiguration.deleteConfig(path);
            } else {
                overrideDTO.setConfigs(newConfigs);
                this.dynamicConfiguration.setConfig(path, YamlParser.dumpObject((Object)overrideDTO));
            }
        } else {
            this.dynamicConfiguration.deleteConfig(path);
        }
        if (overrideDTO.getScope().equals("service")) {
            List overrides = this.convertDTOtoOldOverride(old);
            for (Override o : overrides) {
                this.registry.unregister(o.toUrl().addParameter("compatible_config", true));
            }
        }
    }

    public void enableOverride(String id) {
        String path;
        String config;
        if (StringUtils.isEmpty((CharSequence)id)) {
            // empty if block
        }
        if ((config = this.dynamicConfiguration.getConfig(path = this.getPath(id))) == null) {
            // empty if block
        }
        OverrideDTO override = (OverrideDTO)YamlParser.loadObject((String)config, OverrideDTO.class);
        DynamicConfigDTO old = OverrideUtils.createFromOverride((OverrideDTO)override);
        override.setEnabled(true);
        this.dynamicConfiguration.setConfig(path, YamlParser.dumpObject((Object)override));
        if (override.getScope().equals("service")) {
            List overrides = this.convertDTOtoOldOverride(old);
            for (Override o : overrides) {
                o.setEnabled(false);
                this.registry.unregister(o.toUrl().addParameter("compatible_config", true));
                o.setEnabled(true);
                this.registry.register(o.toUrl().addParameter("compatible_config", true));
            }
        }
    }

    public void disableOverride(String id) {
        String path;
        if (StringUtils.isEmpty((CharSequence)id)) {
            // empty if block
        }
        if (this.dynamicConfiguration.getConfig(path = this.getPath(id)) == null) {
            // empty if block
        }
        String config = this.dynamicConfiguration.getConfig(path);
        OverrideDTO override = (OverrideDTO)YamlParser.loadObject((String)config, OverrideDTO.class);
        DynamicConfigDTO old = OverrideUtils.createFromOverride((OverrideDTO)override);
        override.setEnabled(false);
        this.dynamicConfiguration.setConfig(path, YamlParser.dumpObject((Object)override));
        if (override.getScope().equals("service")) {
            List overrides = this.convertDTOtoOldOverride(old);
            for (Override o : overrides) {
                o.setEnabled(true);
                this.registry.unregister(o.toUrl().addParameter("compatible_config", true));
                o.setEnabled(false);
                this.registry.register(o.toUrl().addParameter("compatible_config", true));
            }
        }
    }

    public DynamicConfigDTO findOverride(String id) {
        String path;
        String config;
        if (StringUtils.isEmpty((CharSequence)id)) {
            // empty if block
        }
        if ((config = this.dynamicConfiguration.getConfig(path = this.getPath(id))) != null) {
            OverrideDTO overrideDTO = (OverrideDTO)YamlParser.loadObject((String)config, OverrideDTO.class);
            return OverrideUtils.createFromOverride((OverrideDTO)overrideDTO);
        }
        return null;
    }

    public void saveWeight(WeightDTO weightDTO) {
        String id = ConvertUtil.getIdFromDTO((BaseDTO)weightDTO);
        String scope = ConvertUtil.getScopeFromDTO((BaseDTO)weightDTO);
        String path = this.getPath(id);
        String config = this.dynamicConfiguration.getConfig(path);
        OverrideConfig overrideConfig = OverrideUtils.weightDTOtoConfig((WeightDTO)weightDTO);
        OverrideDTO overrideDTO = this.insertConfig(config, overrideConfig, id, scope, "weight");
        this.dynamicConfiguration.setConfig(path, YamlParser.dumpObject((Object)overrideDTO));
        if (scope.equals("service")) {
            this.registerWeight(weightDTO);
        }
    }

    public void updateWeight(WeightDTO weightDTO) {
        OverrideDTO overrideDTO;
        List configs;
        String id = ConvertUtil.getIdFromDTO((BaseDTO)weightDTO);
        String scope = ConvertUtil.getScopeFromDTO((BaseDTO)weightDTO);
        String path = this.getPath(id);
        String config = this.dynamicConfiguration.getConfig(path);
        WeightDTO oldWeight = null;
        if (config != null && (configs = (overrideDTO = (OverrideDTO)YamlParser.loadObject((String)config, OverrideDTO.class)).getConfigs()) != null && configs.size() > 0) {
            for (OverrideConfig overrideConfig : configs) {
                if (!"weight".equals(overrideConfig.getType())) continue;
                if (overrideDTO.getScope().equals("service")) {
                    oldWeight = OverrideUtils.configtoWeightDTO((OverrideConfig)overrideConfig, (String)scope, (String)id);
                }
                int index = configs.indexOf(overrideConfig);
                OverrideConfig newConfig = OverrideUtils.weightDTOtoConfig((WeightDTO)weightDTO);
                configs.set(index, newConfig);
                break;
            }
            this.dynamicConfiguration.setConfig(path, YamlParser.dumpObject((Object)overrideDTO));
        }
        if (oldWeight != null) {
            this.unregisterWeight(oldWeight);
            this.registerWeight(weightDTO);
        }
    }

    public void deleteWeight(String id) {
        String path = this.getPath(id);
        String config = this.dynamicConfiguration.getConfig(path);
        OverrideConfig oldConfig = null;
        if (config != null) {
            OverrideDTO overrideDTO = (OverrideDTO)YamlParser.loadObject((String)config, OverrideDTO.class);
            List configs = overrideDTO.getConfigs();
            if (configs != null) {
                for (OverrideConfig overrideConfig : configs) {
                    if (!"weight".equals(overrideConfig.getType())) continue;
                    if (overrideDTO.getScope().equals("service")) {
                        oldConfig = overrideConfig;
                    }
                    configs.remove(overrideConfig);
                    break;
                }
                if (configs.size() == 0) {
                    this.dynamicConfiguration.deleteConfig(path);
                } else {
                    this.dynamicConfiguration.setConfig(path, YamlParser.dumpObject((Object)overrideDTO));
                }
            }
            if (oldConfig != null) {
                String key = overrideDTO.getKey();
                WeightDTO weightDTO = OverrideUtils.configtoWeightDTO(oldConfig, (String)overrideDTO.getScope(), (String)key);
                this.unregisterWeight(weightDTO);
            }
        }
    }

    public WeightDTO findWeight(String id) {
        OverrideDTO overrideDTO;
        List configs;
        String path = this.getPath(id);
        String config = this.dynamicConfiguration.getConfig(path);
        if (config != null && (configs = (overrideDTO = (OverrideDTO)YamlParser.loadObject((String)config, OverrideDTO.class)).getConfigs()) != null) {
            for (OverrideConfig overrideConfig : configs) {
                if (!"weight".equals(overrideConfig.getType())) continue;
                WeightDTO weightDTO = OverrideUtils.configtoWeightDTO((OverrideConfig)overrideConfig, (String)overrideDTO.getScope(), (String)id);
                return weightDTO;
            }
        }
        return null;
    }

    public void saveBalance(BalancingDTO balancingDTO) {
        String id = ConvertUtil.getIdFromDTO((BaseDTO)balancingDTO);
        String scope = ConvertUtil.getScopeFromDTO((BaseDTO)balancingDTO);
        String path = this.getPath(id);
        String config = this.dynamicConfiguration.getConfig(path);
        OverrideConfig overrideConfig = OverrideUtils.balancingDTOtoConfig((BalancingDTO)balancingDTO);
        OverrideDTO overrideDTO = this.insertConfig(config, overrideConfig, id, scope, "balancing");
        this.dynamicConfiguration.setConfig(path, YamlParser.dumpObject((Object)overrideDTO));
        if (scope.equals("service")) {
            this.registerBalancing(balancingDTO);
        }
    }

    public void updateBalance(BalancingDTO balancingDTO) {
        OverrideDTO overrideDTO;
        List configs;
        String id = ConvertUtil.getIdFromDTO((BaseDTO)balancingDTO);
        String scope = ConvertUtil.getScopeFromDTO((BaseDTO)balancingDTO);
        String path = this.getPath(id);
        String config = this.dynamicConfiguration.getConfig(path);
        BalancingDTO oldBalancing = null;
        if (config != null && (configs = (overrideDTO = (OverrideDTO)YamlParser.loadObject((String)config, OverrideDTO.class)).getConfigs()) != null && configs.size() > 0) {
            for (OverrideConfig overrideConfig : configs) {
                if (!"balancing".equals(overrideConfig.getType())) continue;
                if (overrideDTO.getScope().equals("service")) {
                    oldBalancing = OverrideUtils.configtoBalancingDTO((OverrideConfig)overrideConfig, (String)"service", (String)overrideDTO.getKey());
                }
                int index = configs.indexOf(overrideConfig);
                OverrideConfig newConfig = OverrideUtils.balancingDTOtoConfig((BalancingDTO)balancingDTO);
                configs.set(index, newConfig);
                break;
            }
            this.dynamicConfiguration.setConfig(path, YamlParser.dumpObject((Object)overrideDTO));
        }
        if (oldBalancing != null) {
            this.unregisterBalancing(oldBalancing);
            this.registerBalancing(balancingDTO);
        }
    }

    public void deleteBalance(String id) {
        String path = this.getPath(id);
        String config = this.dynamicConfiguration.getConfig(path);
        OverrideConfig oldConfig = null;
        if (config != null) {
            OverrideDTO overrideDTO = (OverrideDTO)YamlParser.loadObject((String)config, OverrideDTO.class);
            List configs = overrideDTO.getConfigs();
            if (configs != null) {
                for (OverrideConfig overrideConfig : configs) {
                    if (!"balancing".equals(overrideConfig.getType())) continue;
                    if (overrideDTO.getScope().equals("service")) {
                        oldConfig = overrideConfig;
                    }
                    configs.remove(overrideConfig);
                    break;
                }
                if (configs.size() == 0) {
                    this.dynamicConfiguration.deleteConfig(path);
                } else {
                    this.dynamicConfiguration.setConfig(path, YamlParser.dumpObject((Object)overrideDTO));
                }
            }
            if (oldConfig != null) {
                String key = overrideDTO.getKey();
                BalancingDTO balancingDTO = OverrideUtils.configtoBalancingDTO(oldConfig, (String)"service", (String)key);
                this.unregisterBalancing(balancingDTO);
            }
        }
    }

    public BalancingDTO findBalance(String id) {
        OverrideDTO overrideDTO;
        List configs;
        String path = this.getPath(id);
        String config = this.dynamicConfiguration.getConfig(path);
        if (config != null && (configs = (overrideDTO = (OverrideDTO)YamlParser.loadObject((String)config, OverrideDTO.class)).getConfigs()) != null) {
            for (OverrideConfig overrideConfig : configs) {
                if (!"balancing".equals(overrideConfig.getType())) continue;
                BalancingDTO balancingDTO = OverrideUtils.configtoBalancingDTO((OverrideConfig)overrideConfig, (String)overrideDTO.getScope(), (String)id);
                return balancingDTO;
            }
        }
        return null;
    }

    private OverrideDTO insertConfig(String config, OverrideConfig overrideConfig, String key, String scope, String configType) {
        OverrideDTO overrideDTO = null;
        if (config == null) {
            overrideDTO = new OverrideDTO();
            overrideDTO.setKey(key);
            overrideDTO.setScope(scope);
            ArrayList<OverrideConfig> configs = new ArrayList<OverrideConfig>();
            configs.add(overrideConfig);
            overrideDTO.setConfigs(configs);
        } else {
            overrideDTO = (OverrideDTO)YamlParser.loadObject((String)config, OverrideDTO.class);
            ArrayList<OverrideConfig> configs = overrideDTO.getConfigs();
            if (configs != null) {
                for (OverrideConfig o : configs) {
                    if (!configType.equals(o.getType())) continue;
                    configs.remove(o);
                    break;
                }
                configs.add(overrideConfig);
            } else {
                configs = new ArrayList<OverrideConfig>();
                configs.add(overrideConfig);
            }
            overrideDTO.setConfigs(configs);
        }
        return overrideDTO;
    }

    private void overrideDTOToParams(Override override, OverrideConfig config) {
        int length;
        Map parameters = config.getParameters();
        StringBuilder params = new StringBuilder();
        if (parameters != null) {
            for (Map.Entry entry : parameters.entrySet()) {
                String value = (String)entry.getKey() + "=" + entry.getValue();
                params.append(value).append("&");
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)params) && params.charAt((length = params.length()) - 1) == '&') {
            params.deleteCharAt(length - 1);
        }
        override.setParams(params.toString());
    }

    private List<Override> convertDTOtoOldOverride(DynamicConfigDTO overrideDTO) {
        ArrayList<Override> result = new ArrayList<Override>();
        List configs = overrideDTO.getConfigs();
        for (OverrideConfig config : configs) {
            if (Constants.CONFIGS.contains(config.getType())) continue;
            List apps = config.getApplications();
            List addresses = config.getAddresses();
            for (String address : addresses) {
                if (apps != null && apps.size() > 0) {
                    for (String app : apps) {
                        Override override = new Override();
                        override.setService(overrideDTO.getService());
                        override.setAddress(address);
                        override.setEnabled(overrideDTO.isEnabled());
                        this.overrideDTOToParams(override, config);
                        override.setApplication(app);
                        result.add(override);
                    }
                    continue;
                }
                Override override = new Override();
                override.setService(overrideDTO.getService());
                override.setAddress(address);
                override.setEnabled(overrideDTO.isEnabled());
                this.overrideDTOToParams(override, config);
                result.add(override);
            }
        }
        return result;
    }

    private String getPath(String key) {
        key = key.replace("/", "*");
        return this.prefix + "/" + key + ".configurators";
    }

    private void unregisterWeight(WeightDTO weightDTO) {
        List addresses = weightDTO.getAddresses();
        if (addresses != null) {
            Weight weight = new Weight();
            weight.setService(weightDTO.getService());
            weight.setWeight(weightDTO.getWeight());
            for (String address : addresses) {
                weight.setAddress(address);
                WeightToOverrideAdapter override = new WeightToOverrideAdapter(weight);
                this.registry.unregister(override.toUrl());
            }
        }
    }

    private void registerWeight(WeightDTO weightDTO) {
        List addresses = weightDTO.getAddresses();
        if (addresses != null) {
            Weight weight = new Weight();
            weight.setService(weightDTO.getService());
            weight.setWeight(weightDTO.getWeight());
            for (String address : addresses) {
                weight.setAddress(address);
                WeightToOverrideAdapter override = new WeightToOverrideAdapter(weight);
                this.registry.register(override.toUrl());
            }
        }
    }

    private void unregisterBalancing(BalancingDTO balancingDTO) {
        LoadBalance loadBalance = new LoadBalance();
        loadBalance.setService(balancingDTO.getService());
        loadBalance.setMethod(balancingDTO.getMethodName());
        loadBalance.setStrategy(balancingDTO.getStrategy());
        this.registry.unregister(new LoadBalance2OverrideAdapter(loadBalance).toUrl());
    }

    private void registerBalancing(BalancingDTO balancingDTO) {
        LoadBalance loadBalance = new LoadBalance();
        loadBalance.setService(balancingDTO.getService());
        loadBalance.setMethod(balancingDTO.getMethodName());
        loadBalance.setStrategy(balancingDTO.getStrategy());
        this.registry.register(new LoadBalance2OverrideAdapter(loadBalance).toUrl());
    }
}

