/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.admin.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.dubbo.admin.common.exception.ParamValidationException;
import org.apache.dubbo.admin.common.util.Pair;
import org.apache.dubbo.admin.common.util.ParseUtils;
import org.apache.dubbo.admin.common.util.SyncUtils;
import org.apache.dubbo.admin.common.util.Tool;
import org.apache.dubbo.admin.model.domain.Provider;
import org.apache.dubbo.admin.model.dto.ServiceDTO;
import org.apache.dubbo.admin.service.OverrideService;
import org.apache.dubbo.admin.service.ProviderService;
import org.apache.dubbo.admin.service.impl.AbstractService;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.metadata.report.identifier.MetadataIdentifier;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProviderServiceImpl
extends AbstractService
implements ProviderService {
    @Autowired
    OverrideService overrideService;

    public void create(Provider provider) {
        URL url = provider.toUrl();
        this.registry.register(url);
    }

    public String getProviderMetaData(MetadataIdentifier providerIdentifier) {
        return this.metaDataCollector.getProviderMetaData(providerIdentifier);
    }

    public void deleteStaticProvider(String id) {
        URL oldProvider = this.findProviderUrl(id);
        if (oldProvider == null) {
            throw new IllegalStateException("Provider was changed!");
        }
        this.registry.unregister(oldProvider);
    }

    public void updateProvider(Provider provider) {
        String hash = provider.getHash();
        if (hash == null) {
            throw new IllegalStateException("no provider id");
        }
        URL oldProvider = this.findProviderUrl(hash);
        if (oldProvider == null) {
            throw new IllegalStateException("Provider was changed!");
        }
        URL newProvider = provider.toUrl();
        this.registry.unregister(oldProvider);
        this.registry.register(newProvider);
    }

    public Provider findProvider(String id) {
        return SyncUtils.url2Provider((Pair)this.findProviderUrlPair(id));
    }

    public Pair<String, URL> findProviderUrlPair(String id) {
        return SyncUtils.filterFromCategory((Map)this.getRegistryCache(), (String)"providers", (String)id);
    }

    public Set<String> findServices() {
        HashSet<String> ret = new HashSet<String>();
        ConcurrentMap providerUrls = (ConcurrentMap)this.getRegistryCache().get("providers");
        if (providerUrls != null) {
            ret.addAll(providerUrls.keySet());
        }
        return ret;
    }

    public List<String> findAddresses() {
        ArrayList<String> ret = new ArrayList<String>();
        ConcurrentMap providerUrls = (ConcurrentMap)this.getRegistryCache().get("providers");
        if (null == providerUrls) {
            return ret;
        }
        for (Map.Entry e1 : providerUrls.entrySet()) {
            Map value = (Map)e1.getValue();
            for (Map.Entry e2 : value.entrySet()) {
                URL u = (URL)e2.getValue();
                String app = u.getAddress();
                if (app == null) continue;
                ret.add(app);
            }
        }
        return ret;
    }

    public List<String> findAddressesByApplication(String application) {
        ArrayList<String> ret = new ArrayList<String>();
        ConcurrentMap providerUrls = (ConcurrentMap)this.getRegistryCache().get("providers");
        for (Map.Entry e1 : providerUrls.entrySet()) {
            Map value = (Map)e1.getValue();
            for (Map.Entry e2 : value.entrySet()) {
                String addr;
                URL u = (URL)e2.getValue();
                if (!application.equals(u.getParameter("application")) || (addr = u.getAddress()) == null) continue;
                ret.add(addr);
            }
        }
        return ret;
    }

    public List<String> findAddressesByService(String service) {
        ArrayList<String> ret = new ArrayList<String>();
        ConcurrentMap providerUrls = (ConcurrentMap)this.getRegistryCache().get("providers");
        if (null == providerUrls) {
            return ret;
        }
        for (Map.Entry e2 : ((Map)providerUrls.get(service)).entrySet()) {
            URL u = (URL)e2.getValue();
            String app = u.getAddress();
            if (app == null) continue;
            ret.add(app);
        }
        return ret;
    }

    public List<String> findApplicationsByServiceName(String service) {
        ArrayList<String> ret = new ArrayList<String>();
        ConcurrentMap providerUrls = (ConcurrentMap)this.getRegistryCache().get("providers");
        if (null == providerUrls) {
            return ret;
        }
        Map value = (Map)providerUrls.get(service);
        if (value == null) {
            return ret;
        }
        for (Map.Entry e2 : value.entrySet()) {
            URL u = (URL)e2.getValue();
            String app = u.getParameter("application");
            if (app == null) continue;
            ret.add(app);
        }
        return ret;
    }

    public List<Provider> findByService(String serviceName) {
        return SyncUtils.url2ProviderList((Map)this.findProviderUrlByService(serviceName));
    }

    public List<Provider> findByAppandService(String app, String serviceName) {
        return SyncUtils.url2ProviderList((Map)this.findProviderUrlByAppandService(app, serviceName));
    }

    private Map<String, URL> findProviderUrlByService(String service) {
        HashMap<String, String> filter = new HashMap<String, String>();
        filter.put("category", "providers");
        filter.put(".service", service);
        return SyncUtils.filterFromCategory((Map)this.getRegistryCache(), filter);
    }

    public List<Provider> findAll() {
        return SyncUtils.url2ProviderList((Map)this.findAllProviderUrl());
    }

    private Map<String, URL> findAllProviderUrl() {
        HashMap<String, String> filter = new HashMap<String, String>();
        filter.put("category", "providers");
        return SyncUtils.filterFromCategory((Map)this.getRegistryCache(), filter);
    }

    public List<Provider> findByAddress(String providerAddress) {
        return SyncUtils.url2ProviderList((Map)this.findProviderUrlByAddress(providerAddress));
    }

    public Map<String, URL> findProviderUrlByAddress(String address) {
        HashMap<String, String> filter = new HashMap<String, String>();
        filter.put("category", "providers");
        filter.put(".address", address);
        return SyncUtils.filterFromCategory((Map)this.getRegistryCache(), filter);
    }

    public List<String> findServicesByAddress(String address) {
        ArrayList<String> ret = new ArrayList<String>();
        ConcurrentMap providerUrls = (ConcurrentMap)this.getRegistryCache().get("providers");
        if (providerUrls == null || address == null || address.length() == 0) {
            return ret;
        }
        block0: for (Map.Entry e1 : providerUrls.entrySet()) {
            Map value = (Map)e1.getValue();
            for (Map.Entry e2 : value.entrySet()) {
                URL u = (URL)e2.getValue();
                if (!address.equals(u.getAddress())) continue;
                ret.add((String)e1.getKey());
                continue block0;
            }
        }
        return ret;
    }

    public Set<String> findApplications() {
        HashSet<String> ret = new HashSet<String>();
        ConcurrentMap providerUrls = (ConcurrentMap)this.getRegistryCache().get("providers");
        if (providerUrls == null) {
            return ret;
        }
        for (Map.Entry e1 : providerUrls.entrySet()) {
            Map value = (Map)e1.getValue();
            for (Map.Entry e2 : value.entrySet()) {
                URL u = (URL)e2.getValue();
                String app = u.getParameter("application");
                if (app == null) continue;
                ret.add(app);
            }
        }
        return ret;
    }

    public List<Provider> findByApplication(String application) {
        return SyncUtils.url2ProviderList((Map)this.findProviderUrlByApplication(application));
    }

    public String findVersionInApplication(String application) {
        List services = this.findServicesByApplication(application);
        if (services == null || services.size() == 0) {
            throw new ParamValidationException("there is no service for application: " + application);
        }
        return this.findServiceVersion((String)services.get(0), application);
    }

    public String findServiceVersion(String serviceName, String application) {
        URL url;
        String version = "2.6";
        Map result = this.findProviderUrlByAppandService(application, serviceName);
        if (result != null && result.size() > 0 && (url = (URL)result.values().stream().findFirst().get()).getParameter("release") != null) {
            version = url.getParameter("release");
        }
        return version;
    }

    private Map<String, URL> findProviderUrlByAppandService(String app, String service) {
        HashMap<String, String> filter = new HashMap<String, String>();
        filter.put("category", "providers");
        filter.put("application", app);
        filter.put(".service", service);
        return SyncUtils.filterFromCategory((Map)this.getRegistryCache(), filter);
    }

    private Map<String, URL> findProviderUrlByApplication(String application) {
        HashMap<String, String> filter = new HashMap<String, String>();
        filter.put("category", "providers");
        filter.put("application", application);
        return SyncUtils.filterFromCategory((Map)this.getRegistryCache(), filter);
    }

    public List<String> findServicesByApplication(String application) {
        ArrayList<String> ret = new ArrayList<String>();
        ConcurrentMap providerUrls = (ConcurrentMap)this.getRegistryCache().get("providers");
        if (providerUrls == null || application == null || application.length() == 0) {
            return ret;
        }
        block0: for (Map.Entry e1 : providerUrls.entrySet()) {
            Map value = (Map)e1.getValue();
            for (Map.Entry e2 : value.entrySet()) {
                URL u = (URL)e2.getValue();
                if (!application.equals(u.getParameter("application"))) continue;
                ret.add((String)e1.getKey());
                continue block0;
            }
        }
        return ret;
    }

    public List<String> findMethodsByService(String service) {
        ArrayList<String> ret = new ArrayList<String>();
        ConcurrentMap providerUrls = (ConcurrentMap)this.getRegistryCache().get("providers");
        if (providerUrls == null || service == null || service.length() == 0) {
            return ret;
        }
        Map providers = (Map)providerUrls.get(service);
        if (null == providers || providers.isEmpty()) {
            return ret;
        }
        Map.Entry p = providers.entrySet().iterator().next();
        String value = ((URL)p.getValue()).getParameter("methods");
        if (value == null || value.length() == 0) {
            return ret;
        }
        String[] methods = value.split(ParseUtils.METHOD_SPLIT);
        if (methods == null || methods.length == 0) {
            return ret;
        }
        for (String m : methods) {
            ret.add(m);
        }
        return ret;
    }

    private URL findProviderUrl(String id) {
        return this.findProvider(id).toUrl();
    }

    public Provider findByServiceAndAddress(String service, String address) {
        return SyncUtils.url2Provider((Pair)this.findProviderUrl(service, address));
    }

    private Pair<String, URL> findProviderUrl(String service, String address) {
        HashMap<String, String> filter = new HashMap<String, String>();
        filter.put("category", "providers");
        filter.put(".address", address);
        Map ret = SyncUtils.filterFromCategory((Map)this.getRegistryCache(), filter);
        if (ret.isEmpty()) {
            return null;
        }
        String key = (String)ret.entrySet().iterator().next().getKey();
        return new Pair((Object)key, ret.get(key));
    }

    public Set<ServiceDTO> getServiceDTOS(String pattern, String filter, String env) {
        List providers;
        block11: {
            block9: {
                block12: {
                    block10: {
                        providers = new ArrayList();
                        if (filter.contains("*") || filter.contains("?")) break block9;
                        if (!"ip".equals(pattern)) break block10;
                        providers = this.findByAddress(filter);
                        break block11;
                    }
                    if (!"service".equals(pattern)) break block12;
                    providers = this.findByService(filter);
                    break block11;
                }
                if (!"application".equals(pattern)) break block11;
                providers = this.findByApplication(filter);
                break block11;
            }
            Set candidates = Collections.emptySet();
            if ("service".equals(pattern)) {
                candidates = this.findServices();
            } else if ("application".equals(pattern)) {
                candidates = this.findApplications();
            } else if ("ip".equals(pattern)) {
                candidates = this.findAddresses().stream().collect(Collectors.toSet());
            }
            filter = filter.toLowerCase().replace(".", "\\.");
            if (filter.startsWith("*") || filter.startsWith("?") || filter.startsWith("+")) {
                filter = "." + filter;
            }
            Pattern regex = Pattern.compile(filter, 2);
            for (String candidate : candidates) {
                Matcher matcher = regex.matcher(candidate);
                if (!matcher.matches() && !matcher.lookingAt()) continue;
                if ("service".equals(pattern)) {
                    providers.addAll(this.findByService(candidate));
                    continue;
                }
                if ("ip".equals(pattern)) {
                    providers.addAll(this.findByAddress(candidate));
                    continue;
                }
                providers.addAll(this.findByApplication(candidate));
            }
        }
        Set result = this.convertProviders2DTO(providers);
        return result;
    }

    public Set<ServiceDTO> convertProviders2DTO(List<Provider> providers) {
        TreeSet<ServiceDTO> result = new TreeSet<ServiceDTO>();
        for (Provider provider : providers) {
            String app = provider.getApplication();
            String service = provider.getService();
            String group = Tool.getGroup((String)service);
            String version = Tool.getVersion((String)service);
            String interfaze = Tool.getInterface((String)service);
            ServiceDTO s = new ServiceDTO();
            s.setAppName(app);
            s.setService(interfaze);
            s.setGroup(group);
            s.setVersion(version);
            result.add(s);
        }
        return result;
    }
}

