/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.admin.service.impl;

import java.util.LinkedList;
import java.util.List;
import org.apache.dubbo.admin.common.exception.ResourceNotFoundException;
import org.apache.dubbo.admin.common.util.ConvertUtil;
import org.apache.dubbo.admin.common.util.RouteUtils;
import org.apache.dubbo.admin.common.util.YamlParser;
import org.apache.dubbo.admin.model.domain.Route;
import org.apache.dubbo.admin.model.dto.AccessDTO;
import org.apache.dubbo.admin.model.dto.BaseDTO;
import org.apache.dubbo.admin.model.dto.ConditionRouteDTO;
import org.apache.dubbo.admin.model.dto.TagRouteDTO;
import org.apache.dubbo.admin.model.store.RoutingRule;
import org.apache.dubbo.admin.model.store.TagRoute;
import org.apache.dubbo.admin.service.RouteService;
import org.apache.dubbo.admin.service.impl.AbstractService;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class RouteServiceImpl
extends AbstractService
implements RouteService {
    private String prefix = "config/dubbo";

    public void createConditionRoute(ConditionRouteDTO conditionRoute) {
        String id = ConvertUtil.getIdFromDTO((BaseDTO)conditionRoute);
        String path = this.getPath(id, "condition_route");
        String existConfig = this.dynamicConfiguration.getConfig(path);
        RoutingRule existRule = null;
        if (existConfig != null) {
            existRule = (RoutingRule)YamlParser.loadObject((String)existConfig, RoutingRule.class);
        }
        existRule = RouteUtils.insertConditionRule(existRule, (ConditionRouteDTO)conditionRoute);
        this.dynamicConfiguration.setConfig(path, YamlParser.dumpObject((Object)existRule));
        if (StringUtils.isNotEmpty((String)conditionRoute.getService())) {
            for (Route old : this.convertRouteToOldRoute(conditionRoute)) {
                this.registry.register(old.toUrl().addParameter("compatible_config", true));
            }
        }
    }

    public void updateConditionRoute(ConditionRouteDTO newConditionRoute) {
        String id = ConvertUtil.getIdFromDTO((BaseDTO)newConditionRoute);
        String path = this.getPath(id, "condition_route");
        String existConfig = this.dynamicConfiguration.getConfig(path);
        if (existConfig == null) {
            throw new ResourceNotFoundException("no existing condition route for path: " + path);
        }
        RoutingRule routingRule = (RoutingRule)YamlParser.loadObject((String)existConfig, RoutingRule.class);
        ConditionRouteDTO oldConditionRoute = RouteUtils.createConditionRouteFromRule((RoutingRule)routingRule);
        routingRule = RouteUtils.insertConditionRule((RoutingRule)routingRule, (ConditionRouteDTO)newConditionRoute);
        this.dynamicConfiguration.setConfig(path, YamlParser.dumpObject((Object)routingRule));
        if (StringUtils.isNotEmpty((String)newConditionRoute.getService())) {
            for (Route old : this.convertRouteToOldRoute(oldConditionRoute)) {
                this.registry.unregister(old.toUrl().addParameter("compatible_config", true));
            }
            for (Route updated : this.convertRouteToOldRoute(newConditionRoute)) {
                this.registry.register(updated.toUrl().addParameter("compatible_config", true));
            }
        }
    }

    public void deleteConditionRoute(String id) {
        RoutingRule route;
        List blackWhiteList;
        String path;
        String config;
        if (StringUtils.isEmpty((String)id)) {
            // empty if block
        }
        if ((config = this.dynamicConfiguration.getConfig(path = this.getPath(id, "condition_route"))) == null) {
            // empty if block
        }
        if ((blackWhiteList = RouteUtils.filterBlackWhiteListFromConditions((List)(route = (RoutingRule)YamlParser.loadObject((String)config, RoutingRule.class)).getConditions())).size() != 0) {
            route.setConditions(blackWhiteList);
            this.dynamicConfiguration.setConfig(path, YamlParser.dumpObject((Object)route));
        } else {
            this.dynamicConfiguration.deleteConfig(path);
        }
        if (route.getScope().equals("service")) {
            RoutingRule originRule = (RoutingRule)YamlParser.loadObject((String)config, RoutingRule.class);
            ConditionRouteDTO conditionRouteDTO = RouteUtils.createConditionRouteFromRule((RoutingRule)originRule);
            for (Route old : this.convertRouteToOldRoute(conditionRouteDTO)) {
                this.registry.unregister(old.toUrl().addParameter("compatible_config", true));
            }
        }
    }

    public void deleteAccess(String id) {
        String path = this.getPath(id, "condition_route");
        String config = this.dynamicConfiguration.getConfig(path);
        if (config != null) {
            RoutingRule ruleDTO = (RoutingRule)YamlParser.loadObject((String)config, RoutingRule.class);
            List blackWhiteList = RouteUtils.filterBlackWhiteListFromConditions((List)ruleDTO.getConditions());
            List conditions = RouteUtils.filterConditionRuleFromConditions((List)ruleDTO.getConditions());
            if (conditions.size() == 0) {
                this.dynamicConfiguration.deleteConfig(path);
            } else {
                ruleDTO.setConditions(conditions);
                this.dynamicConfiguration.setConfig(path, YamlParser.dumpObject((Object)ruleDTO));
            }
            if (ruleDTO.getScope().equals("service") && blackWhiteList.size() > 0) {
                Route route = RouteUtils.convertBlackWhiteListtoRoute((List)blackWhiteList, (String)"service", (String)id);
                this.registry.unregister(route.toUrl());
            }
        }
    }

    public void createAccess(AccessDTO accessDTO) {
        RoutingRule ruleDTO;
        String id = ConvertUtil.getIdFromDTO((BaseDTO)accessDTO);
        String path = this.getPath(id, "condition_route");
        String config = this.dynamicConfiguration.getConfig(path);
        List blackWhiteList = RouteUtils.convertToBlackWhiteList((AccessDTO)accessDTO);
        if (config == null) {
            ruleDTO = new RoutingRule();
            ruleDTO.setEnabled(true);
            if (StringUtils.isNoneEmpty((String[])new String[]{accessDTO.getApplication()})) {
                ruleDTO.setScope("application");
            } else {
                ruleDTO.setScope("service");
            }
            ruleDTO.setKey(id);
            ruleDTO.setConditions(blackWhiteList);
        } else {
            ruleDTO = (RoutingRule)YamlParser.loadObject((String)config, RoutingRule.class);
            if (ruleDTO.getConditions() == null) {
                ruleDTO.setConditions(blackWhiteList);
            } else {
                ruleDTO.getConditions().addAll(blackWhiteList);
            }
        }
        this.dynamicConfiguration.setConfig(path, YamlParser.dumpObject((Object)ruleDTO));
        if (ruleDTO.getScope().equals("service")) {
            Route route = RouteUtils.convertAccessDTOtoRoute((AccessDTO)accessDTO);
            this.registry.register(route.toUrl());
        }
    }

    public AccessDTO findAccess(String id) {
        String path = this.getPath(id, "condition_route");
        String config = this.dynamicConfiguration.getConfig(path);
        if (config != null) {
            RoutingRule ruleDTO = (RoutingRule)YamlParser.loadObject((String)config, RoutingRule.class);
            List blackWhiteList = RouteUtils.filterBlackWhiteListFromConditions((List)ruleDTO.getConditions());
            return RouteUtils.convertToAccessDTO((List)blackWhiteList, (String)ruleDTO.getScope(), (String)ruleDTO.getKey());
        }
        return null;
    }

    public void updateAccess(AccessDTO accessDTO) {
        String key = ConvertUtil.getIdFromDTO((BaseDTO)accessDTO);
        String path = this.getPath(key, "condition_route");
        List blackWhiteList = RouteUtils.convertToBlackWhiteList((AccessDTO)accessDTO);
        String config = this.dynamicConfiguration.getConfig(path);
        List oldList = null;
        if (config != null) {
            RoutingRule ruleDTO = (RoutingRule)YamlParser.loadObject((String)config, RoutingRule.class);
            oldList = RouteUtils.filterBlackWhiteListFromConditions((List)ruleDTO.getConditions());
            List conditions = RouteUtils.filterConditionRuleFromConditions((List)ruleDTO.getConditions());
            conditions.addAll(blackWhiteList);
            ruleDTO.setConditions(conditions);
            this.dynamicConfiguration.setConfig(path, YamlParser.dumpObject((Object)ruleDTO));
        }
        if (StringUtils.isNotEmpty((String)accessDTO.getService())) {
            Route oldRoute = RouteUtils.convertBlackWhiteListtoRoute(oldList, (String)"service", (String)key);
            Route newRoute = RouteUtils.convertAccessDTOtoRoute((AccessDTO)accessDTO);
            this.registry.unregister(oldRoute.toUrl());
            this.registry.register(newRoute.toUrl());
        }
    }

    public void enableConditionRoute(String id) {
        String path = this.getPath(id, "condition_route");
        String config = this.dynamicConfiguration.getConfig(path);
        if (config != null) {
            RoutingRule ruleDTO = (RoutingRule)YamlParser.loadObject((String)config, RoutingRule.class);
            if (ruleDTO.getScope().equals("service")) {
                for (Route oldRoute : this.convertRouteToOldRoute(RouteUtils.createConditionRouteFromRule((RoutingRule)ruleDTO))) {
                    URL oldURL = oldRoute.toUrl();
                    this.registry.unregister(oldURL);
                    oldURL = oldURL.addParameter("enabled", true);
                    this.registry.register(oldURL);
                }
            }
            ruleDTO.setEnabled(true);
            this.dynamicConfiguration.setConfig(path, YamlParser.dumpObject((Object)ruleDTO));
        }
    }

    public void disableConditionRoute(String serviceName) {
        String path = this.getPath(serviceName, "condition_route");
        String config = this.dynamicConfiguration.getConfig(path);
        if (config != null) {
            RoutingRule routeRule = (RoutingRule)YamlParser.loadObject((String)config, RoutingRule.class);
            if (routeRule.getScope().equals("service")) {
                for (Route oldRoute : this.convertRouteToOldRoute(RouteUtils.createConditionRouteFromRule((RoutingRule)routeRule))) {
                    URL oldURL = oldRoute.toUrl();
                    this.registry.unregister(oldURL);
                    oldURL = oldURL.addParameter("enabled", false);
                    this.registry.register(oldURL);
                }
            }
            routeRule.setEnabled(false);
            this.dynamicConfiguration.setConfig(path, YamlParser.dumpObject((Object)routeRule));
        }
    }

    public ConditionRouteDTO findConditionRoute(String id) {
        String path = this.getPath(id, "condition_route");
        String config = this.dynamicConfiguration.getConfig(path);
        if (config != null) {
            RoutingRule routingRule = (RoutingRule)YamlParser.loadObject((String)config, RoutingRule.class);
            ConditionRouteDTO conditionRouteDTO = RouteUtils.createConditionRouteFromRule((RoutingRule)routingRule);
            String service = conditionRouteDTO.getService();
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)service)) {
                conditionRouteDTO.setService(service.replace("*", "/"));
            }
            return conditionRouteDTO;
        }
        return null;
    }

    public void createTagRoute(TagRouteDTO tagRoute) {
        String id = ConvertUtil.getIdFromDTO((BaseDTO)tagRoute);
        String path = this.getPath(id, "tag_route");
        TagRoute store = RouteUtils.convertTagroutetoStore((TagRouteDTO)tagRoute);
        this.dynamicConfiguration.setConfig(path, YamlParser.dumpObject((Object)store));
    }

    public void updateTagRoute(TagRouteDTO tagRoute) {
        String id = ConvertUtil.getIdFromDTO((BaseDTO)tagRoute);
        String path = this.getPath(id, "tag_route");
        if (this.dynamicConfiguration.getConfig(path) == null) {
            throw new ResourceNotFoundException("can not find tagroute: " + id);
        }
        TagRoute store = RouteUtils.convertTagroutetoStore((TagRouteDTO)tagRoute);
        this.dynamicConfiguration.setConfig(path, YamlParser.dumpObject((Object)store));
    }

    public void deleteTagRoute(String id) {
        String path = this.getPath(id, "tag_route");
        this.dynamicConfiguration.deleteConfig(path);
    }

    public void enableTagRoute(String id) {
        String path = this.getPath(id, "tag_route");
        String config = this.dynamicConfiguration.getConfig(path);
        if (config != null) {
            TagRoute tagRoute = (TagRoute)YamlParser.loadObject((String)config, TagRoute.class);
            tagRoute.setEnabled(true);
            this.dynamicConfiguration.setConfig(path, YamlParser.dumpObject((Object)tagRoute));
        }
    }

    public void disableTagRoute(String id) {
        String path = this.getPath(id, "tag_route");
        String config = this.dynamicConfiguration.getConfig(path);
        if (config != null) {
            TagRoute tagRoute = (TagRoute)YamlParser.loadObject((String)config, TagRoute.class);
            tagRoute.setEnabled(false);
            this.dynamicConfiguration.setConfig(path, YamlParser.dumpObject((Object)tagRoute));
        }
    }

    public TagRouteDTO findTagRoute(String id) {
        String path = this.getPath(id, "tag_route");
        String config = this.dynamicConfiguration.getConfig(path);
        if (config != null) {
            TagRoute tagRoute = (TagRoute)YamlParser.loadObject((String)config, TagRoute.class);
            return RouteUtils.convertTagroutetoDisplay((TagRoute)tagRoute);
        }
        return null;
    }

    private String getPath(String key, String type) {
        key = key.replace("/", "*");
        if (type.equals("condition_route")) {
            return this.prefix + "/" + key + ".condition-router";
        }
        return this.prefix + "/" + key + ".tag-router";
    }

    private String parseCondition(String condition) {
        StringBuilder when = new StringBuilder();
        StringBuilder then = new StringBuilder();
        if ((condition = condition.trim()).contains("=>")) {
            String[] array = condition.split("=>", 2);
            String consumer = array[0].trim();
            String provider = array[1].trim();
            if (consumer.length() != 0) {
                if (when.length() != 0) {
                    when.append(" & ").append(consumer);
                } else {
                    when.append(consumer);
                }
            }
            if (provider.length() != 0) {
                if (then.length() != 0) {
                    then.append(" & ").append(provider);
                } else {
                    then.append(provider);
                }
            }
        }
        return when.append(" => ").append((CharSequence)then).toString();
    }

    private List<Route> convertRouteToOldRoute(ConditionRouteDTO route) {
        LinkedList<Route> oldList = new LinkedList<Route>();
        for (String condition : route.getConditions()) {
            Route old = new Route();
            old.setService(route.getService());
            old.setEnabled(route.isEnabled());
            old.setForce(route.isForce());
            old.setRuntime(route.isRuntime());
            old.setPriority(route.getPriority());
            String rule = this.parseCondition(condition);
            old.setRule(rule);
            oldList.add(old);
        }
        return oldList;
    }
}

