/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.admin.utils;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ReferenceConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.rpc.service.GenericService;

/*
 * Exception performing whole class analysis ignored.
 */
public class ApiDocsDubboGenericUtil {
    private static ApplicationConfig application;
    private static Map<String, RegistryConfig> registryConfigCache;
    private static Map<String, ReferenceConfig<GenericService>> referenceCache;
    private static final ScheduledExecutorService EXECUTOR;
    private static int retries;
    private static int timeout;

    public static void setRetriesAndTimeout(int retries, int timeout) {
        ApiDocsDubboGenericUtil.retries = retries;
        ApiDocsDubboGenericUtil.timeout = timeout;
    }

    private static RegistryConfig getRegistryConfig(String address) {
        RegistryConfig registryConfig = (RegistryConfig)registryConfigCache.get(address);
        if (null == registryConfig) {
            registryConfig = new RegistryConfig();
            registryConfig.setAddress(address);
            registryConfig.setRegister(Boolean.valueOf(false));
            registryConfigCache.put(address, registryConfig);
        }
        return registryConfig;
    }

    private static void removeRegistryConfig(String address) {
        registryConfigCache.remove(address);
    }

    private static ReferenceConfig<GenericService> getReferenceConfig(String address, String interfaceName, String version) {
        String key = ApiDocsDubboGenericUtil.buildCacheKey((String)address, (String)interfaceName, (String)version);
        ReferenceConfig referenceConfig = (ReferenceConfig)referenceCache.get(key);
        if (null == referenceConfig) {
            referenceConfig = new ReferenceConfig();
            referenceConfig.setRetries(Integer.valueOf(retries));
            referenceConfig.setTimeout(Integer.valueOf(timeout));
            referenceConfig.setVersion(version);
            referenceConfig.setApplication(application);
            if (address.startsWith("dubbo")) {
                referenceConfig.setUrl(address);
            } else {
                referenceConfig.setRegistry(ApiDocsDubboGenericUtil.getRegistryConfig((String)address));
            }
            referenceConfig.setInterface(interfaceName);
            referenceConfig.setGeneric(Boolean.valueOf(true));
            referenceCache.put(key, referenceConfig);
        }
        return referenceConfig;
    }

    private static void removeReferenceConfig(String address, String interfaceName, String version) {
        ApiDocsDubboGenericUtil.removeRegistryConfig((String)address);
        referenceCache.remove(ApiDocsDubboGenericUtil.buildCacheKey((String)address, (String)interfaceName, (String)version));
    }

    private static String buildCacheKey(String address, String interfaceName, String version) {
        return address + "/" + interfaceName + "/" + version;
    }

    public static CompletableFuture<Object> invoke(String address, String interfaceName, String methodName, boolean async, String version, String[] paramTypes, Object[] paramValues) {
        CompletableFuture<Object> future = null;
        ReferenceConfig reference = ApiDocsDubboGenericUtil.getReferenceConfig((String)address, (String)interfaceName, (String)version);
        if (null != reference) {
            GenericService genericService = (GenericService)reference.get();
            if (null != genericService) {
                future = async ? genericService.$invokeAsync(methodName, paramTypes, paramValues) : CompletableFuture.supplyAsync(() -> genericService.$invoke(methodName, paramTypes, paramValues), EXECUTOR);
            }
            future.exceptionally(ex -> {
                if (StringUtils.contains((CharSequence)ex.toString(), (CharSequence)"Failed to invoke remote method")) {
                    ApiDocsDubboGenericUtil.removeReferenceConfig((String)address, (String)interfaceName, (String)version);
                }
                return ex;
            });
        }
        return future;
    }

    public static Object invokeSync(String address, String interfaceName, String methodName, String version, String[] paramTypes, Object[] paramValues) {
        ReferenceConfig reference = ApiDocsDubboGenericUtil.getReferenceConfig((String)address, (String)interfaceName, (String)version);
        if (null != reference) {
            GenericService genericService = (GenericService)reference.get();
            try {
                if (null != genericService) {
                    return genericService.$invoke(methodName, paramTypes, paramValues);
                }
            }
            catch (Exception ex) {
                if (StringUtils.contains((CharSequence)ex.toString(), (CharSequence)"Failed to invoke remote method")) {
                    ApiDocsDubboGenericUtil.removeReferenceConfig((String)address, (String)interfaceName, (String)version);
                }
                throw ex;
            }
        }
        return null;
    }

    static {
        retries = 2;
        timeout = 1000;
        EXECUTOR = new ScheduledThreadPoolExecutor(Runtime.getRuntime().availableProcessors() * 40 * 3, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("dubbo-async-executor-pool-%d").daemon(true).build());
        application = new ApplicationConfig();
        application.setName("dubbo-admin-api-docs");
        registryConfigCache = new ConcurrentHashMap();
        referenceCache = new ConcurrentHashMap();
    }
}

