/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.admin.common.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.admin.common.util.Tool;
import org.apache.dubbo.admin.model.dto.BaseDTO;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metadata.definition.model.MethodDefinition;

public class ConvertUtil {
    private ConvertUtil() {
    }

    public static Map<String, String> serviceName2Map(String serviceName) {
        String group = Tool.getGroup((String)serviceName);
        String version = Tool.getVersion((String)serviceName);
        String interfaze = Tool.getInterface((String)serviceName);
        HashMap<String, String> ret = new HashMap<String, String>();
        if (!StringUtils.isEmpty((String)serviceName)) {
            ret.put("interface", interfaze);
        }
        if (!StringUtils.isEmpty((String)version)) {
            ret.put("version", version);
        }
        if (!StringUtils.isEmpty((String)group)) {
            ret.put("group", group);
        }
        return ret;
    }

    public static String getIdFromDTO(BaseDTO baseDTO) {
        String id = StringUtils.isNotEmpty((String)baseDTO.getApplication()) ? baseDTO.getApplication() : baseDTO.getService();
        return id;
    }

    public static String getScopeFromDTO(BaseDTO baseDTO) {
        if (StringUtils.isNotEmpty((String)baseDTO.getApplication())) {
            return "application";
        }
        return "service";
    }

    public static Map methodList2Map(List<MethodDefinition> methods) {
        HashMap<String, MethodDefinition> res = new HashMap<String, MethodDefinition>();
        for (int i = 0; i < methods.size(); ++i) {
            res.put(methods.get(i).getName(), methods.get(i));
        }
        return res;
    }
}

