/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.admin.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.admin.common.util.Pair;
import org.apache.dubbo.admin.model.domain.Consumer;
import org.apache.dubbo.admin.model.domain.Provider;
import org.apache.dubbo.common.URL;

/*
 * Exception performing whole class analysis ignored.
 */
public class SyncUtils {
    public static final String SERVICE_FILTER_KEY = ".service";
    public static final String ADDRESS_FILTER_KEY = ".address";
    public static final String ID_FILTER_KEY = ".id";
    public static final String COLON = ":";

    public static Provider url2Provider(Pair<String, URL> pair) {
        if (pair == null) {
            return null;
        }
        String id = (String)pair.getKey();
        URL url = (URL)pair.getValue();
        if (url == null) {
            return null;
        }
        Provider p = new Provider();
        p.setHash(id);
        p.setService(url.getServiceKey());
        p.setAddress(url.getAddress());
        p.setApplication(url.getParameter("application"));
        p.setUrl(url.toIdentityString());
        p.setParameters(url.toParameterString());
        p.setDynamic(url.getParameter("dynamic", true));
        p.setEnabled(url.getParameter("enabled", true));
        p.setWeight(url.getParameter("weight", 100));
        p.setUsername(url.getParameter("owner"));
        return p;
    }

    public static List<Provider> url2ProviderList(Map<String, URL> ps) {
        ArrayList<Provider> ret = new ArrayList<Provider>();
        for (Map.Entry<String, URL> entry : ps.entrySet()) {
            ret.add(SyncUtils.url2Provider((Pair)new Pair((Object)entry.getKey(), (Object)entry.getValue())));
        }
        return ret;
    }

    public static Consumer url2Consumer(Pair<String, URL> pair) {
        if (pair == null) {
            return null;
        }
        String id = (String)pair.getKey();
        URL url = (URL)pair.getValue();
        if (null == url) {
            return null;
        }
        Consumer c = new Consumer();
        c.setHash(id);
        c.setService(url.getServiceKey());
        c.setAddress(url.getHost());
        c.setApplication(url.getParameter("application"));
        c.setParameters(url.toParameterString());
        return c;
    }

    public static List<Consumer> url2ConsumerList(Map<String, URL> cs) {
        ArrayList<Consumer> list = new ArrayList<Consumer>();
        if (cs == null) {
            return list;
        }
        for (Map.Entry<String, URL> entry : cs.entrySet()) {
            list.add(SyncUtils.url2Consumer((Pair)new Pair((Object)entry.getKey(), (Object)entry.getValue())));
        }
        return list;
    }

    public static <SM extends Map<String, Map<String, URL>>> Map<String, URL> filterFromCategory(Map<String, SM> urls, Map<String, String> filter) {
        String c = filter.get("category");
        if (c == null) {
            throw new IllegalArgumentException("no category");
        }
        filter.remove("category");
        return SyncUtils.filterFromService((Map)((Map)urls.get(c)), filter);
    }

    public static Map<String, URL> filterFromService(Map<String, Map<String, URL>> urls, Map<String, String> filter) {
        HashMap<String, URL> ret = new HashMap<String, URL>();
        if (urls == null) {
            return ret;
        }
        String s = filter.remove(".service");
        if (s == null) {
            for (Map.Entry<String, Map<String, URL>> entry : urls.entrySet()) {
                SyncUtils.filterFromUrls(entry.getValue(), ret, filter);
            }
        } else {
            Map<String, URL> map = urls.get(s);
            SyncUtils.filterFromUrls(map, ret, filter);
        }
        return ret;
    }

    static void filterFromUrls(Map<String, URL> from, Map<String, URL> to, Map<String, String> filter) {
        if (from == null || from.isEmpty()) {
            return;
        }
        for (Map.Entry<String, URL> entry : from.entrySet()) {
            URL url = entry.getValue();
            boolean match = true;
            for (Map.Entry<String, String> e : filter.entrySet()) {
                String key = e.getKey();
                String value = e.getValue();
                if (".address".equals(key)) {
                    if (value.contains(":")) {
                        if (value.equals(url.getIp() + ":" + url.getPort())) continue;
                        match = false;
                        break;
                    }
                    if (value.equals(url.getIp())) continue;
                    match = false;
                    break;
                }
                if (value.equals(url.getParameter(key))) continue;
                match = false;
                break;
            }
            if (!match) continue;
            to.put(entry.getKey(), url);
        }
    }

    public static <SM extends Map<String, Map<String, URL>>> Pair<String, URL> filterFromCategory(Map<String, SM> urls, String category, String id) {
        Map services = (Map)urls.get(category);
        if (services == null) {
            return null;
        }
        for (Map.Entry e1 : services.entrySet()) {
            Map u = (Map)e1.getValue();
            if (!u.containsKey(id)) continue;
            return new Pair((Object)id, u.get(id));
        }
        return null;
    }
}

