/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.admin.controller;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.admin.annotation.Authority;
import org.apache.dubbo.admin.common.exception.ParamValidationException;
import org.apache.dubbo.admin.common.exception.ResourceNotFoundException;
import org.apache.dubbo.admin.common.exception.VersionValidationException;
import org.apache.dubbo.admin.model.dto.AccessDTO;
import org.apache.dubbo.admin.model.dto.ConditionRouteDTO;
import org.apache.dubbo.admin.service.ProviderService;
import org.apache.dubbo.admin.service.RouteService;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Authority(needLogin=true)
@RestController
@RequestMapping(value={"/api/{env}/rules/access"})
public class AccessesController {
    private static final Logger logger = LoggerFactory.getLogger(AccessesController.class);
    private final RouteService routeService;
    private final ProviderService providerService;

    @Autowired
    public AccessesController(RouteService routeService, ProviderService providerService) {
        this.routeService = routeService;
        this.providerService = providerService;
    }

    @RequestMapping(method={RequestMethod.GET})
    public List<AccessDTO> searchAccess(@RequestParam(required=false) String service, @RequestParam(required=false) String application, @PathVariable String env) {
        if (StringUtils.isBlank((CharSequence)service) && StringUtils.isBlank((CharSequence)application)) {
            throw new ParamValidationException("Either service or application is required");
        }
        ArrayList<AccessDTO> accessDTOS = new ArrayList<AccessDTO>();
        AccessDTO accessDTO = StringUtils.isNotBlank((CharSequence)application) ? this.routeService.findAccess(application) : this.routeService.findAccess(service);
        if (accessDTO != null) {
            accessDTO.setEnabled(true);
            accessDTOS.add(accessDTO);
        }
        return accessDTOS;
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET})
    public AccessDTO detailAccess(@PathVariable String id, @PathVariable String env) {
        id = id.replace("*", "/");
        AccessDTO accessDTO = this.routeService.findAccess(id);
        return accessDTO;
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE})
    public void deleteAccess(@PathVariable String id, @PathVariable String env) {
        id = id.replace("*", "/");
        this.routeService.deleteAccess(id);
    }

    @RequestMapping(method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.CREATED)
    public void createAccess(@RequestBody AccessDTO accessDTO, @PathVariable String env) {
        if (StringUtils.isBlank((CharSequence)accessDTO.getService()) && StringUtils.isBlank((CharSequence)accessDTO.getApplication())) {
            throw new ParamValidationException("Either Service or application is required.");
        }
        String application = accessDTO.getApplication();
        if (StringUtils.isNotEmpty((CharSequence)application) && "2.6".equals(this.providerService.findVersionInApplication(application))) {
            throw new VersionValidationException("dubbo 2.6 does not support application scope blackwhite list config");
        }
        if (accessDTO.getBlacklist() == null && accessDTO.getWhitelist() == null) {
            throw new ParamValidationException("One of Blacklist/Whitelist is required.");
        }
        this.routeService.createAccess(accessDTO);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.PUT})
    public void updateAccess(@PathVariable String id, @RequestBody AccessDTO accessDTO, @PathVariable String env) {
        ConditionRouteDTO route = this.routeService.findConditionRoute(id = id.replace("*", "/"));
        if (Objects.isNull(route)) {
            throw new ResourceNotFoundException("Unknown ID!");
        }
        this.routeService.updateAccess(accessDTO);
    }
}

