/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.admin.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.SimplePropertyPreFilter;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.beans.PropertyEditor;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.admin.controller.editors.CustomLocalDateEditor;
import org.apache.dubbo.admin.controller.editors.CustomLocalDateTimeEditor;
import org.apache.dubbo.admin.model.dto.docs.ApiInfoRequest;
import org.apache.dubbo.admin.model.dto.docs.CallDubboServiceRequest;
import org.apache.dubbo.admin.model.dto.docs.CallDubboServiceRequestInterfaceParam;
import org.apache.dubbo.admin.utils.ApiDocsDubboGenericUtil;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.propertyeditors.StringTrimmerEditor;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@Api(tags={"dubbo-api-docs-api"})
@RestController
@RequestMapping(value={"/api/{env}/docs"})
public class ApiDocsController {
    private static final Logger LOG = LoggerFactory.getLogger(ApiDocsController.class);
    private static final SimplePropertyPreFilter CLASS_NAME_PRE_FILTER = new SimplePropertyPreFilter(HashMap.class, new String[0]);
    @Value(value="${dubbo.consumer.retries:0}")
    private int retries;
    @Value(value="${dubbo.consumer.timeout:1000}")
    private int timeout;

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        binder.registerCustomEditor(String.class, (PropertyEditor)new StringTrimmerEditor(true));
        binder.registerCustomEditor(LocalDate.class, (PropertyEditor)new CustomLocalDateEditor());
        binder.registerCustomEditor(LocalDateTime.class, (PropertyEditor)new CustomLocalDateTimeEditor());
    }

    @PostConstruct
    public void setRetriesAndTimeout() {
        ApiDocsDubboGenericUtil.setRetriesAndTimeout((int)this.retries, (int)this.timeout);
    }

    @ApiOperation(value="request dubbo api", notes="request dubbo api", httpMethod="POST", produces="application/json")
    @PostMapping(value={"/requestDubbo"})
    public String callDubboService(CallDubboServiceRequest dubboCfg, @RequestBody List<CallDubboServiceRequestInterfaceParam> methodparams) {
        String[] paramTypes = null;
        Object[] paramValues = null;
        if (null != methodparams && !methodparams.isEmpty()) {
            paramTypes = new String[methodparams.size()];
            paramValues = new Object[methodparams.size()];
            for (int i = 0; i < methodparams.size(); ++i) {
                CallDubboServiceRequestInterfaceParam param = methodparams.get(i);
                paramTypes[i] = param.getParamType();
                Object paramValue = param.getParamValue();
                if (ApiDocsController.isBaseType((String)param.getParamType()) && null != paramValue) {
                    if (paramValue instanceof Map) {
                        Map tempMap = (Map)paramValue;
                        if (tempMap.isEmpty()) continue;
                        Object tempParamValue = tempMap.values().stream().findFirst().orElse(null);
                        paramValues[i] = this.emptyString2Null(tempParamValue);
                        continue;
                    }
                    paramValues[i] = this.emptyString2Null(paramValue);
                    continue;
                }
                this.emptyString2Null(paramValue);
                paramValues[i] = paramValue;
            }
        }
        if (null == paramTypes) {
            paramTypes = new String[]{};
        }
        if (null == paramValues) {
            paramValues = new Object[]{};
        }
        CompletableFuture future = ApiDocsDubboGenericUtil.invoke((String)dubboCfg.getRegistryCenterUrl(), (String)dubboCfg.getInterfaceClassName(), (String)dubboCfg.getMethodName(), (boolean)dubboCfg.isAsync(), (String)dubboCfg.getVersion(), (String[])paramTypes, (Object[])paramValues);
        try {
            Object objResult = future.get();
            return JSON.toJSONString(objResult, (SerializeFilter)CLASS_NAME_PRE_FILTER, (SerializerFeature[])new SerializerFeature[0]);
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return "Some exceptions have occurred, please check the log.";
        }
    }

    private Object emptyString2Null(Object paramValue) {
        if (null != paramValue) {
            if (paramValue instanceof String && StringUtils.isBlank((CharSequence)((String)paramValue))) {
                return null;
            }
            if (paramValue instanceof Map) {
                Map tempMap = (Map)paramValue;
                tempMap.forEach((k, v) -> {
                    if (v != null && v instanceof String && StringUtils.isBlank((CharSequence)((String)v))) {
                        tempMap.put(k, null);
                    } else {
                        this.emptyString2Null(v);
                    }
                });
            }
        }
        return paramValue;
    }

    @ApiOperation(value="Get basic information of all modules, excluding API parameter information", notes="Get basic information of all modules, excluding API parameter information", httpMethod="GET", produces="application/json")
    @GetMapping(value={"/apiModuleList"})
    public String apiModuleList(ApiInfoRequest apiInfoRequest) {
        CallDubboServiceRequest req = new CallDubboServiceRequest();
        req.setRegistryCenterUrl("dubbo://" + apiInfoRequest.getDubboIp() + ":" + apiInfoRequest.getDubboPort());
        req.setInterfaceClassName("org.apache.dubbo.apidocs.core.providers.IDubboDocProvider");
        req.setMethodName("apiModuleList");
        req.setAsync(false);
        return this.callDubboService(req, null);
    }

    @ApiOperation(value="Get the parameter information of the specified API", notes="Get the parameter information of the specified API", httpMethod="GET", produces="application/json")
    @GetMapping(value={"/apiParamsResp"})
    public String apiParamsResp(ApiInfoRequest apiInfoRequest) {
        CallDubboServiceRequest req = new CallDubboServiceRequest();
        req.setRegistryCenterUrl("dubbo://" + apiInfoRequest.getDubboIp() + ":" + apiInfoRequest.getDubboPort());
        req.setInterfaceClassName("org.apache.dubbo.apidocs.core.providers.IDubboDocProvider");
        req.setMethodName("apiParamsResponseInfo");
        req.setAsync(false);
        ArrayList<CallDubboServiceRequestInterfaceParam> methodparams = new ArrayList<CallDubboServiceRequestInterfaceParam>(1);
        CallDubboServiceRequestInterfaceParam param = new CallDubboServiceRequestInterfaceParam();
        param.setParamType(String.class.getName());
        param.setParamValue((Object)apiInfoRequest.getApiName());
        methodparams.add(param);
        return this.callDubboService(req, methodparams);
    }

    private static boolean isBaseType(String typeStr) {
        return "java.lang.Integer".equals(typeStr) || "java.lang.Byte".equals(typeStr) || "java.lang.Long".equals(typeStr) || "java.lang.Double".equals(typeStr) || "java.lang.Float".equals(typeStr) || "java.lang.Character".equals(typeStr) || "java.lang.Short".equals(typeStr) || "java.lang.Boolean".equals(typeStr) || "java.lang.String".equals(typeStr);
    }

    static {
        CLASS_NAME_PRE_FILTER.getExcludes().add("class");
    }
}

