/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.admin.controller;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.admin.annotation.Authority;
import org.apache.dubbo.admin.common.exception.ParamValidationException;
import org.apache.dubbo.admin.common.exception.ResourceNotFoundException;
import org.apache.dubbo.admin.common.exception.VersionValidationException;
import org.apache.dubbo.admin.model.dto.TagRouteDTO;
import org.apache.dubbo.admin.service.ProviderService;
import org.apache.dubbo.admin.service.RouteService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Authority(needLogin=true)
@RestController
@RequestMapping(value={"/api/{env}/rules/route/tag"})
public class TagRoutesController {
    private final RouteService routeService;
    private final ProviderService providerService;

    @Autowired
    public TagRoutesController(RouteService routeService, ProviderService providerService) {
        this.routeService = routeService;
        this.providerService = providerService;
    }

    @RequestMapping(method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.CREATED)
    public boolean createRule(@RequestBody TagRouteDTO routeDTO, @PathVariable String env) {
        String app = routeDTO.getApplication();
        if (StringUtils.isEmpty((CharSequence)app)) {
            throw new ParamValidationException("app is Empty!");
        }
        if (this.providerService.findVersionInApplication(app).equals("2.6")) {
            throw new VersionValidationException("dubbo 2.6 does not support tag route");
        }
        this.routeService.createTagRoute(routeDTO);
        return true;
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.PUT})
    public boolean updateRule(@PathVariable String id, @RequestBody TagRouteDTO routeDTO, @PathVariable String env) {
        id = id.replace("*", "/");
        String app = routeDTO.getApplication();
        if (this.providerService.findVersionInApplication(app).equals("2.6")) {
            throw new VersionValidationException("dubbo 2.6 does not support tag route");
        }
        if (this.routeService.findTagRoute(id) == null) {
            throw new ResourceNotFoundException("can not find tag route, Id: " + id);
        }
        this.routeService.updateTagRoute(routeDTO);
        return true;
    }

    @RequestMapping(method={RequestMethod.GET})
    public List<TagRouteDTO> searchRoutes(@RequestParam String application, @PathVariable String env) {
        if (StringUtils.isBlank((CharSequence)application)) {
            throw new ParamValidationException("application is required.");
        }
        ArrayList<TagRouteDTO> result = new ArrayList<TagRouteDTO>();
        String version = "2.6";
        try {
            version = this.providerService.findVersionInApplication(application);
        }
        catch (ParamValidationException paramValidationException) {
            // empty catch block
        }
        if (version.equals("2.6")) {
            return result;
        }
        TagRouteDTO tagRoute = this.routeService.findTagRoute(application);
        if (tagRoute != null) {
            result.add(tagRoute);
        }
        return result;
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET})
    public TagRouteDTO detailRoute(@PathVariable String id, @PathVariable String env) {
        TagRouteDTO tagRoute = this.routeService.findTagRoute(id = id.replace("*", "/"));
        if (tagRoute == null) {
            throw new ResourceNotFoundException("Unknown ID!");
        }
        return tagRoute;
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE})
    public boolean deleteRoute(@PathVariable String id, @PathVariable String env) {
        id = id.replace("*", "/");
        this.routeService.deleteTagRoute(id);
        return true;
    }

    @RequestMapping(value={"/enable/{id}"}, method={RequestMethod.PUT})
    public boolean enableRoute(@PathVariable String id, @PathVariable String env) {
        id = id.replace("*", "/");
        this.routeService.enableTagRoute(id);
        return true;
    }

    @RequestMapping(value={"/disable/{id}"}, method={RequestMethod.PUT})
    public boolean disableRoute(@PathVariable String id, @PathVariable String env) {
        id = id.replace("*", "/");
        this.routeService.disableTagRoute(id);
        return true;
    }
}

