/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.admin.controller;

import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.admin.annotation.Authority;
import org.apache.dubbo.admin.controller.UserController;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@RestController
@RequestMapping(value={"/api/{env}/user"})
public class UserController {
    public static Map<String, User> tokenMap = new ConcurrentHashMap();
    @Value(value="${admin.root.user.name:}")
    private String rootUserName;
    @Value(value="${admin.root.user.password:}")
    private String rootUserPassword;
    @Value(value="${admin.check.sessionTimeoutMilli:3600000}")
    private long sessionTimeoutMilli;

    @RequestMapping(value={"/login"}, method={RequestMethod.GET})
    public String login(@RequestParam String userName, @RequestParam String password) {
        if (StringUtils.isBlank((CharSequence)this.rootUserName) || this.rootUserName.equals(userName) && this.rootUserPassword.equals(password)) {
            UUID uuid = UUID.randomUUID();
            String token = uuid.toString();
            User user = new User();
            user.setUserName(userName);
            user.setLastUpdateTime(System.currentTimeMillis());
            tokenMap.put(token, user);
            return token;
        }
        return null;
    }

    @Authority(needLogin=true)
    @RequestMapping(value={"/logout"}, method={RequestMethod.DELETE})
    public boolean logout() {
        HttpServletRequest request = ((ServletRequestAttributes)Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getRequest();
        String token = request.getHeader("Authorization");
        return null != tokenMap.remove(token);
    }

    @Scheduled(cron="0 5 * * * ?")
    public void clearExpiredToken() {
        tokenMap.entrySet().removeIf(entry -> entry.getValue() == null || System.currentTimeMillis() - ((User)entry.getValue()).getLastUpdateTime() > this.sessionTimeoutMilli);
    }
}

