/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.admin.model.domain;

import java.util.List;
import org.apache.dubbo.admin.common.util.Tool;
import org.apache.dubbo.admin.model.domain.Entity;
import org.apache.dubbo.common.URL;

public class Route
extends Entity {
    public static final String ALL_METHOD = "*";
    public static final String KEY_METHOD = "method";
    public static final String KEY_CONSUMER_APPLICATION = "consumer.application";
    public static final String KEY_CONSUMER_GROUP = "consumer.cluster";
    public static final String KEY_CONSUMER_VERSION = "consumer.version";
    public static final String KEY_CONSUMER_HOST = "host";
    public static final String KEY_CONSUMER_METHODS = "consumer.methods";
    public static final String KEY_PROVIDER_APPLICATION = "provider.application";
    public static final String KEY_PROVIDER_GROUP = "provider.cluster";
    public static final String KEY_PROVIDER_PROTOCOL = "provider.protocol";
    public static final String KEY_PROVIDER_VERSION = "provider.version";
    public static final String KEY_PROVIDER_HOST = "provider.host";
    public static final String KEY_PROVIDER_PORT = "provider.port";
    private static final long serialVersionUID = -7630589008164140656L;
    private long parentId;
    private String name;
    private String service;
    private String rule;
    private String matchRule;
    private String filterRule;
    private int priority;
    private String username;
    private boolean enabled;
    private boolean force;
    private boolean dynamic;
    private boolean runtime;
    private List<Route> children;

    public Route() {
    }

    public Route(Long id) {
        super(id);
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public long getParentId() {
        return this.parentId;
    }

    public void setParentId(long parentId) {
        this.parentId = parentId;
    }

    public List<Route> getChildren() {
        return this.children;
    }

    public void setChildren(List<Route> subRules) {
        this.children = subRules;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public boolean isRuntime() {
        return this.runtime;
    }

    public void setRuntime(boolean runtime) {
        this.runtime = runtime;
    }

    public boolean isForce() {
        return this.force;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public String getRule() {
        return this.rule;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setRule(String rule) {
        this.rule = rule.trim();
        String[] rules = rule.split("=>");
        if (rules.length != 2) {
            if (!rule.endsWith("=>")) throw new IllegalArgumentException("Illegal Route Condition Rule");
            this.matchRule = rules[0].trim();
            this.filterRule = "";
            return;
        } else {
            this.matchRule = rules[0].trim();
            this.filterRule = rules[1].trim();
        }
    }

    public String getMatchRule() {
        return this.matchRule;
    }

    public void setMatchRule(String matchRule) {
        this.matchRule = matchRule != null ? matchRule.trim() : matchRule;
    }

    public String getFilterRule() {
        return this.filterRule;
    }

    public void setFilterRule(String filterRule) {
        this.filterRule = filterRule != null ? filterRule.trim() : filterRule;
    }

    public String toString() {
        return "Route [parentId=" + this.parentId + ", name=" + this.name + ", serviceName=" + this.service + ", matchRule=" + this.matchRule + ", filterRule=" + this.filterRule + ", priority=" + this.priority + ", username=" + this.username + ", enabled=" + this.enabled + "]";
    }

    public URL toUrl() {
        String group = Tool.getGroup((String)this.service);
        String version = Tool.getVersion((String)this.service);
        String interfaze = Tool.getInterface((String)this.service);
        return URL.valueOf((String)("route://0.0.0.0/" + interfaze + "?" + "category" + "=" + "routers" + "&router=condition&runtime=" + this.isRuntime() + "&enabled=" + this.isEnabled() + "&priority=" + this.getPriority() + "&force=" + this.isForce() + "&dynamic=" + this.isDynamic() + "&name=" + this.getName() + "&" + "rule" + "=" + URL.encode((String)(this.getMatchRule() + " => " + this.getFilterRule())) + (group == null ? "" : "&group=" + group) + (version == null ? "" : "&version=" + version)));
    }
}

