/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.admin.registry.config.impl;

import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.Response;
import com.ecwid.consul.v1.kv.model.GetValue;
import org.apache.dubbo.admin.registry.config.GovernanceConfiguration;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;

public class ConsulConfiguration
implements GovernanceConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(ConsulConfiguration.class);
    private static final int DEFAULT_PORT = 8500;
    private static final String SLASH = "/";
    private URL url;
    private ConsulClient client;

    public void init() {
        String host = this.url.getHost();
        int port = this.url.getPort() != 0 ? this.url.getPort() : 8500;
        this.client = new ConsulClient(host, port);
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public URL getUrl() {
        return this.url;
    }

    public String setConfig(String key, String value) {
        return this.setConfig(null, key, value);
    }

    public String getConfig(String key) {
        return this.getConfig(null, key);
    }

    public boolean deleteConfig(String key) {
        return this.deleteConfig(null, key);
    }

    public String setConfig(String group, String key, String value) {
        if (group == null) {
            this.client.setKVValue(key, value);
            return value;
        }
        this.client.setKVValue(group + SLASH + key, value);
        return value;
    }

    public String getConfig(String group, String key) {
        if (group == null) {
            Response response = this.client.getKVValue(key);
            if (response.getValue() == null) {
                return null;
            }
            return ((GetValue)response.getValue()).getDecodedValue();
        }
        Response response = this.client.getKVValue(group + SLASH + key);
        return response.getValue() == null ? null : ((GetValue)response.getValue()).getDecodedValue();
    }

    public boolean deleteConfig(String group, String key) {
        try {
            if (group == null) {
                this.client.deleteKVValue(key);
                return true;
            }
            this.client.deleteKVValue(group + SLASH + key);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    public String getPath(String key) {
        return null;
    }

    public String getPath(String group, String key) {
        return null;
    }
}

