/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.admin.registry.config.impl;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.exception.NacosException;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.admin.registry.config.GovernanceConfiguration;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;

public class NacosConfiguration
implements GovernanceConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(NacosConfiguration.class);
    private ConfigService configService;
    private String nameSpace;
    private String group;
    private URL url;

    public void init() {
        this.group = this.url.getParameter("group", "DEFAULT_GROUP");
        this.nameSpace = this.url.getParameter("namespace", "public");
        this.configService = this.buildConfigService(this.url);
    }

    private ConfigService buildConfigService(URL url) {
        Properties nacosProperties = this.buildNacosProperties(url);
        try {
            this.configService = NacosFactory.createConfigService((Properties)nacosProperties);
        }
        catch (NacosException e) {
            if (logger.isErrorEnabled()) {
                logger.error(e.getErrMsg(), (Throwable)e);
            }
            throw new IllegalStateException(e);
        }
        return this.configService;
    }

    private Properties buildNacosProperties(URL url) {
        Properties properties = new Properties();
        this.setServerAddr(url, properties);
        return properties;
    }

    private void setServerAddr(URL url, Properties properties) {
        String serverAddr = url.getHost() + ":" + url.getPort();
        properties.put("serverAddr", serverAddr);
        properties.put("namespace", this.nameSpace);
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public URL getUrl() {
        return this.url;
    }

    public String setConfig(String key, String value) {
        return this.setConfig(this.group, key, value);
    }

    public String getConfig(String key) {
        return this.getConfig(this.group, key);
    }

    public boolean deleteConfig(String key) {
        return this.deleteConfig(this.group, key);
    }

    public String setConfig(String group, String key, String value) {
        String[] groupAndDataId = this.parseGroupAndDataId(key, group);
        if (null == groupAndDataId) {
            return null;
        }
        try {
            this.configService.publishConfig(groupAndDataId[1], groupAndDataId[0], value);
            return value;
        }
        catch (NacosException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String getConfig(String group, String key) {
        String[] groupAndDataId = this.parseGroupAndDataId(key, group);
        if (null == groupAndDataId) {
            return null;
        }
        try {
            return this.configService.getConfig(groupAndDataId[1], groupAndDataId[0], 10000L);
        }
        catch (NacosException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public boolean deleteConfig(String group, String key) {
        String[] groupAndDataId = this.parseGroupAndDataId(key, group);
        if (null == groupAndDataId) {
            return false;
        }
        try {
            return this.configService.removeConfig(groupAndDataId[1], groupAndDataId[0]);
        }
        catch (NacosException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public String getPath(String key) {
        return null;
    }

    public String getPath(String group, String key) {
        return null;
    }

    private String[] parseGroupAndDataId(String key, String group) {
        if ((StringUtils.isBlank((CharSequence)key) || StringUtils.isBlank((CharSequence)group)) && logger.isWarnEnabled()) {
            logger.warn("key or group is blank");
            return null;
        }
        String[] groupAndDataId = new String[2];
        String[] split = key.split("/");
        if (split.length != 3) {
            return null;
        }
        if ("dubbo.properties".equals(split[2])) {
            groupAndDataId[0] = this.group.equals(split[1]) ? this.group : split[1];
            groupAndDataId[1] = split[2];
        } else {
            groupAndDataId[0] = group;
            groupAndDataId[1] = split[1] + "." + split[2];
        }
        return groupAndDataId;
    }
}

