/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.admin.registry.config.impl;

import org.apache.commons.lang3.StringUtils;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.dubbo.admin.registry.config.GovernanceConfiguration;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;

public class ZookeeperConfiguration
implements GovernanceConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(ZookeeperConfiguration.class);
    private CuratorFramework zkClient;
    private URL url;
    private String root;

    public void setUrl(URL url) {
        this.url = url;
    }

    public URL getUrl() {
        return this.url;
    }

    public void init() {
        if (this.url == null) {
            throw new IllegalStateException("server url is null, cannot init");
        }
        CuratorFrameworkFactory.Builder zkClientBuilder = CuratorFrameworkFactory.builder().connectString(this.url.getAddress()).retryPolicy((RetryPolicy)new ExponentialBackoffRetry(1000, 3));
        if (StringUtils.isNotEmpty((CharSequence)this.url.getUsername()) && StringUtils.isNotEmpty((CharSequence)this.url.getPassword())) {
            String auth = this.url.getUsername() + ":" + this.url.getPassword();
            zkClientBuilder.authorization("digest", auth.getBytes());
        }
        this.zkClient = zkClientBuilder.build();
        String group = this.url.getParameter("group", "dubbo");
        if (!group.startsWith("/")) {
            group = "/" + group;
        }
        this.root = group;
        this.zkClient.start();
    }

    public String setConfig(String key, String value) {
        return this.setConfig(null, key, value);
    }

    public String getConfig(String key) {
        return this.getConfig(null, key);
    }

    public boolean deleteConfig(String key) {
        return this.deleteConfig(null, key);
    }

    public String setConfig(String group, String key, String value) {
        if (key == null || value == null) {
            throw new IllegalArgumentException("key or value cannot be null");
        }
        String path = this.getNodePath(key, group);
        try {
            if (this.zkClient.checkExists().forPath(path) == null) {
                this.zkClient.create().creatingParentsIfNeeded().forPath(path);
            }
            this.zkClient.setData().forPath(path, value.getBytes());
            return value;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String getConfig(String group, String key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        String path = this.getNodePath(key, group);
        try {
            if (this.zkClient.checkExists().forPath(path) == null) {
                return null;
            }
            return new String((byte[])this.zkClient.getData().forPath(path));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public boolean deleteConfig(String group, String key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        String path = this.getNodePath(key, group);
        try {
            this.zkClient.delete().forPath(path);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    public String getPath(String key) {
        return this.getNodePath(key, null);
    }

    public String getPath(String group, String key) {
        return this.getNodePath(key, group);
    }

    private String getNodePath(String path, String group) {
        if (path == null) {
            throw new IllegalArgumentException("path cannot be null");
        }
        return this.toRootDir(group) + path;
    }

    private String toRootDir(String group) {
        if (group != null) {
            this.root = !group.startsWith("/") ? "/" + group : group;
        }
        if (this.root.equals("/")) {
            return this.root;
        }
        return this.root + "/";
    }
}

