/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.admin.registry.metadata.impl;

import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.Response;
import com.ecwid.consul.v1.kv.model.GetValue;
import java.util.Objects;
import org.apache.dubbo.admin.registry.metadata.MetaDataCollector;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.metadata.report.identifier.KeyTypeEnum;
import org.apache.dubbo.metadata.report.identifier.MetadataIdentifier;

public class ConsulMetaDataCollector
implements MetaDataCollector {
    private static final Logger LOG = LoggerFactory.getLogger(ConsulMetaDataCollector.class);
    private static final int DEFAULT_PORT = 8500;
    private URL url;
    private ConsulClient client;

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public void init() {
        Objects.requireNonNull(this.url, "metadataUrl require not null");
        String host = this.url.getHost();
        int port = this.url.getPort() != 0 ? this.url.getPort() : 8500;
        this.client = new ConsulClient(host, port);
    }

    public String getProviderMetaData(MetadataIdentifier key) {
        return this.doGetMetaData(key);
    }

    public String getConsumerMetaData(MetadataIdentifier key) {
        return this.doGetMetaData(key);
    }

    private String doGetMetaData(MetadataIdentifier key) {
        try {
            Response response = this.client.getKVValue(key.getUniqueKey(KeyTypeEnum.UNIQUE_KEY));
            return ((GetValue)response.getValue()).getDecodedValue();
        }
        catch (Exception e) {
            LOG.error(String.format("Failed to fetch metadata for %s from consul, cause: %s", key.getUniqueKey(KeyTypeEnum.UNIQUE_KEY), e.getMessage()), (Throwable)e);
            return null;
        }
    }

    ConsulClient getClient() {
        return this.client;
    }
}

