/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.admin.registry.metadata.impl;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.exception.NacosException;
import java.util.Properties;
import org.apache.dubbo.admin.registry.metadata.MetaDataCollector;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.metadata.report.identifier.KeyTypeEnum;
import org.apache.dubbo.metadata.report.identifier.MetadataIdentifier;

public class NacosMetaDataCollector
implements MetaDataCollector {
    private static final Logger logger = LoggerFactory.getLogger(NacosMetaDataCollector.class);
    private ConfigService configService;
    private String group;
    private URL url;

    public void setUrl(URL url) {
        this.url = url;
    }

    public URL getUrl() {
        return this.url;
    }

    public void init() {
        this.group = this.url.getParameter("group", "DEFAULT_GROUP");
        this.configService = this.buildConfigService(this.url);
    }

    private ConfigService buildConfigService(URL url) {
        Properties nacosProperties = this.buildNacosProperties(url);
        try {
            this.configService = NacosFactory.createConfigService((Properties)nacosProperties);
        }
        catch (NacosException e) {
            if (logger.isErrorEnabled()) {
                logger.error(e.getErrMsg(), (Throwable)e);
            }
            throw new IllegalStateException(e);
        }
        return this.configService;
    }

    private Properties buildNacosProperties(URL url) {
        Properties properties = new Properties();
        this.setServerAddr(url, properties);
        return properties;
    }

    private void setServerAddr(URL url, Properties properties) {
        String serverAddr = url.getHost() + ":" + url.getPort();
        properties.put("serverAddr", serverAddr);
    }

    public String getProviderMetaData(MetadataIdentifier key) {
        return this.getMetaData(key);
    }

    public String getConsumerMetaData(MetadataIdentifier key) {
        return this.getMetaData(key);
    }

    private String getMetaData(MetadataIdentifier identifier) {
        try {
            return this.configService.getConfig(identifier.getUniqueKey(KeyTypeEnum.UNIQUE_KEY), this.group, 10000L);
        }
        catch (NacosException e) {
            logger.warn("Failed to get " + identifier + " from nacos, cause: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

