/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.admin.registry.metadata.impl;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.dubbo.admin.registry.metadata.MetaDataCollector;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.metadata.report.identifier.KeyTypeEnum;
import org.apache.dubbo.metadata.report.identifier.MetadataIdentifier;
import org.apache.dubbo.rpc.RpcException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class RedisMetaDataCollector
implements MetaDataCollector {
    private static final Logger logger = LoggerFactory.getLogger(RedisMetaDataCollector.class);
    private URL url;
    private JedisPool pool;
    private static final String META_DATA_SOTRE_TAG = ".metaData";
    Set<HostAndPort> jedisClusterNodes;
    private int timeout;
    private String password;

    public void setUrl(URL url) {
        this.url = url;
    }

    public URL getUrl() {
        return this.url;
    }

    public void init() {
        this.timeout = this.url.getParameter("timeout", 1000);
        this.password = this.url.getPassword();
        if (this.url.getParameter("cluster", false)) {
            String[] addresses;
            this.jedisClusterNodes = new HashSet();
            for (String address : addresses = CommonConstants.COMMA_SPLIT_PATTERN.split(this.url.getAddress())) {
                URL tmpUrl = this.url.setAddress(address);
                this.jedisClusterNodes.add(new HostAndPort(tmpUrl.getHost(), tmpUrl.getPort()));
            }
        } else {
            this.pool = new JedisPool((GenericObjectPoolConfig)new JedisPoolConfig(), this.url.getHost(), this.url.getPort(), this.timeout, this.url.getPassword());
        }
    }

    public String getProviderMetaData(MetadataIdentifier key) {
        return this.doGetMetaData(key);
    }

    public String getConsumerMetaData(MetadataIdentifier key) {
        return this.doGetMetaData(key);
    }

    private String doGetMetaData(MetadataIdentifier identifier) {
        String result;
        block29: {
            result = null;
            if (this.url.getParameter("cluster", false)) {
                try (JedisCluster jedisCluster = new JedisCluster(this.jedisClusterNodes, this.timeout, this.timeout, 2, this.password, new GenericObjectPoolConfig());){
                    result = jedisCluster.get(identifier.getUniqueKey(KeyTypeEnum.UNIQUE_KEY) + META_DATA_SOTRE_TAG);
                    break block29;
                }
                catch (Throwable e) {
                    logger.error("Failed to get " + identifier + " from redis cluster, cause: " + e.getMessage(), e);
                    throw new RpcException("Failed to get " + identifier + " from redis cluster, cause: " + e.getMessage(), e);
                }
            }
            try (Jedis jedis = this.pool.getResource();){
                result = jedis.get(identifier.getUniqueKey(KeyTypeEnum.UNIQUE_KEY) + META_DATA_SOTRE_TAG);
            }
            catch (Throwable e) {
                logger.error("Failed to get " + identifier + " from redis, cause: " + e.getMessage(), e);
                throw new RpcException("Failed to get " + identifier + " from redis, cause: " + e.getMessage(), e);
            }
        }
        return result;
    }
}

