/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.admin.service.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.admin.common.util.SyncUtils;
import org.apache.dubbo.admin.model.domain.Consumer;
import org.apache.dubbo.admin.service.ConsumerService;
import org.apache.dubbo.admin.service.impl.AbstractService;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.metadata.report.identifier.MetadataIdentifier;
import org.springframework.stereotype.Component;

@Component
public class ConsumerServiceImpl
extends AbstractService
implements ConsumerService {
    public List<Consumer> findByService(String service) {
        return SyncUtils.url2ConsumerList((Map)this.findConsumerUrlByService(service));
    }

    public List<Consumer> findAll() {
        return SyncUtils.url2ConsumerList((Map)this.findAllConsumerUrl());
    }

    public String getConsumerMetadata(MetadataIdentifier consumerIdentifier) {
        return this.metaDataCollector.getConsumerMetaData(consumerIdentifier);
    }

    private Map<String, URL> findAllConsumerUrl() {
        HashMap<String, String> filter = new HashMap<String, String>();
        filter.put("category", "consumers");
        return SyncUtils.filterFromCategory((Map)this.getRegistryCache(), filter);
    }

    public List<Consumer> findByAddress(String consumerAddress) {
        return SyncUtils.url2ConsumerList((Map)this.findConsumerUrlByAddress(consumerAddress));
    }

    private Map<String, URL> findConsumerUrlByAddress(String address) {
        HashMap<String, String> filter = new HashMap<String, String>();
        filter.put("category", "consumers");
        filter.put(".address", address);
        return SyncUtils.filterFromCategory((Map)this.getRegistryCache(), filter);
    }

    public Map<String, URL> findConsumerUrlByService(String service) {
        HashMap<String, String> filter = new HashMap<String, String>();
        filter.put("category", "consumers");
        filter.put(".service", service);
        return SyncUtils.filterFromCategory((Map)this.getRegistryCache(), filter);
    }
}

