/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.admin.service.impl;

import javax.annotation.PostConstruct;
import org.apache.dubbo.admin.common.util.Tool;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ReferenceConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.registry.Registry;
import org.apache.dubbo.rpc.service.GenericService;
import org.springframework.stereotype.Component;

@Component
public class GenericServiceImpl {
    private ApplicationConfig applicationConfig;
    private final Registry registry;

    public GenericServiceImpl(Registry registry) {
        this.registry = registry;
    }

    @PostConstruct
    public void init() {
        RegistryConfig registryConfig = new RegistryConfig();
        registryConfig.setAddress(this.registry.getUrl().getProtocol() + "://" + this.registry.getUrl().getAddress());
        registryConfig.setGroup(this.registry.getUrl().getParameter("group"));
        this.applicationConfig = new ApplicationConfig();
        this.applicationConfig.setName("dubbo-admin");
        this.applicationConfig.setRegistry(registryConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(String service, String method, String[] parameterTypes, Object[] params) {
        ReferenceConfig reference = new ReferenceConfig();
        String group = Tool.getGroup((String)service);
        String version = Tool.getVersion((String)service);
        String intf = Tool.getInterface((String)service);
        reference.setGeneric(Boolean.valueOf(true));
        reference.setApplication(this.applicationConfig);
        reference.setInterface(intf);
        reference.setVersion(version);
        reference.setGroup(group);
        try {
            this.removeGenericSymbol(parameterTypes);
            GenericService genericService = (GenericService)reference.get();
            Object object = genericService.$invoke(method, parameterTypes, params);
            return object;
        }
        finally {
            reference.destroy();
        }
    }

    private void removeGenericSymbol(String[] parameterTypes) {
        for (int i = 0; i < parameterTypes.length; ++i) {
            int index = parameterTypes[i].indexOf("<");
            if (index <= -1) continue;
            parameterTypes[i] = parameterTypes[i].substring(0, index);
        }
    }
}

