/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoft.starter.dubbo.cluster.loadbalance;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.cluster.loadbalance.RandomLoadBalance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class DevLoadBalance
extends RandomLoadBalance {
    private static final Logger log = LoggerFactory.getLogger(DevLoadBalance.class);
    public static final String NAME = "dev";
    public static final String METHOD_CALL_LOCAL_MAP_KEY = "%s.%s.%s";

    protected <T> Invoker<T> doSelect(List<Invoker<T>> invokers, URL url, Invocation invocation) {
        ConcurrentHashMap<String, Invoker> invokerLocalIpConcurrentMap = new ConcurrentHashMap<String, Invoker>();
        ConcurrentHashMap<String, Invoker> invokerMethodNameConcurrentMap = new ConcurrentHashMap<String, Invoker>();
        String fromIp = RpcContext.getContext().getAttachment("127.0.0");
        if (fromIp == null) {
            try {
                fromIp = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        }
        String localIp = fromIp.toString();
        List<Invoker<T>> invokerList = this.getInvokerAddrList(invokers, localIp, invocation, invokerLocalIpConcurrentMap, invokerMethodNameConcurrentMap);
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{localIp}) && invokerLocalIpConcurrentMap.containsKey(localIp)) {
            Invoker invoker2 = (Invoker)invokerLocalIpConcurrentMap.get(localIp);
            String invokerKey = this.generatorInvokerKey(invocation, invoker2);
            log.info("invokerKey:{}", (Object)invokerKey);
            if (invoker2.isAvailable() && invokerMethodNameConcurrentMap.containsKey(invokerKey)) {
                return this.callInvoker(invoker2);
            }
        }
        if (!CollectionUtils.isEmpty(invokerList)) {
            invokerList.parallelStream().forEach(invoker -> log.debug("\u83b7\u53d6\u5230\u6d4b\u8bd5\u73af\u5883\u76f8\u5173\u7684\u670d\u52a1\u5217\u8868\uff1a{},\u72b6\u6001\uff1a{}", (Object)invoker.getUrl(), (Object)invoker.isAvailable()));
            log.debug("select call RandomLoadBalance");
            return super.doSelect(invokerList, url, invocation);
        }
        log.debug("select super loadBalance");
        return super.doSelect(invokers, url, invocation);
    }

    private <T> List<Invoker<T>> getInvokerAddrList(List<Invoker<T>> invokers, String localIp, Invocation invocation, ConcurrentMap<String, Invoker> invokerLocalIpConcurrentMap, ConcurrentMap<String, Invoker> invokerMethodNameConcurrentMap) {
        ArrayList<Invoker<T>> invokerList = new ArrayList<Invoker<T>>();
        for (Invoker<T> invoker : invokers) {
            if (invoker.getUrl().getIp().equals(localIp) && invoker.isAvailable()) {
                String invokerKey = this.generatorInvokerKey(invocation, invoker);
                invokerMethodNameConcurrentMap.put(invokerKey, invoker);
                invokerLocalIpConcurrentMap.put(localIp, invoker);
            }
            if (!invoker.getUrl().getIp().contains("10.29.") || !invoker.isAvailable()) continue;
            invokerList.add(invoker);
        }
        return invokerList;
    }

    private <T> String generatorInvokerKey(Invocation invocation, Invoker<T> invoker) {
        String remoteApplicationKey = invoker.getUrl().getParameter("remote.application");
        String serviceKey = invoker.getUrl().getServiceKey();
        String methodName = invocation.getMethodName();
        String invokerKey = String.format(METHOD_CALL_LOCAL_MAP_KEY, remoteApplicationKey, serviceKey, methodName);
        return invokerKey;
    }

    private <T> Invoker<T> callInvoker(Invoker<T> invoker) {
        log.info("call local invoker url :{}", (Object)invoker.getUrl());
        return invoker;
    }
}

