package com.sinosoft.starter.dubbo.filter;

import com.sinosoft.starter.dubbo.constant.DevDubboConstants;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.*;

import java.net.InetAddress;
import java.net.UnknownHostException;

/**
 * 实现dubbo本地转发功能，优先使用本地ip地址，如果本地没有，则使用SIT环境服务
 * Created by Roney on 2021/5/10 15:51.
 */

@Slf4j
@Activate(order = Integer.MIN_VALUE)
public class DevFilter implements Filter {
    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        // log.info("dev filter start");
        //判断是否存在开始ip
        Object fromIp = RpcContext.getContext().getAttachment(DevDubboConstants.START_LOCAL_IP);
        if (fromIp == null) {
            try {
                //第一次调用时，设置开始ip
                fromIp = InetAddress.getLocalHost().getHostAddress();
            } catch (UnknownHostException e) {
                e.printStackTrace();
            }
        }
        // log.info("dev filter set startip is " + fromIp);
        //设置ip信息,这种设置信息，可以在服务提供者进行获取。
        //这种方式是dubbo的隐式传参  有兴趣的参考官方
        // http://dubbo.apache.org/zh-cn/docs/user/demos/attachment.html
        //当然还有url中进行拼接上下文信息，有兴趣的可以任意选择。
        RpcContext.getContext().setAttachment(DevDubboConstants.START_LOCAL_IP, fromIp.toString());
        // log.info("call invoker url :{}",invoker.getUrl());
        return invoker.invoke(invocation);
    }
}
