/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoft.starter.motan.config;

import com.sinosoft.starter.motan.config.MotanCommonConfiguration;
import com.sinosoft.starter.motan.properties.MotanProperties;
import com.weibo.api.motan.config.springsupport.BasicRefererConfigBean;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@ImportAutoConfiguration(value={MotanCommonConfiguration.class})
@Configuration
public class MotanConsumerConfiguration {
    private MotanProperties motanProperties;

    public MotanConsumerConfiguration(MotanProperties motanProperties) {
        this.motanProperties = motanProperties;
    }

    @Bean(name={"motanClientBasicConfig"})
    public BasicRefererConfigBean baseRefererConfig() {
        return this.getBasicRefererConfigBean();
    }

    @Bean(name={"motanClientFastFailConfig"})
    public BasicRefererConfigBean motanClientFastFailConfig() {
        return this.getBasicRefererConfigBean();
    }

    private BasicRefererConfigBean getBasicRefererConfigBean() {
        String motanClientGroup = this.motanProperties.getConsumer().getGroup();
        Integer requestTimeout = this.motanProperties.getConsumer().getRequestTimeout();
        String protocolNames = this.motanProperties.getConsumer().getProtocolNames();
        String registryNames = this.motanProperties.getConsumer().getRegistryNames();
        BasicRefererConfigBean config = new BasicRefererConfigBean();
        config.setProtocol(protocolNames);
        if (motanClientGroup == null) {
            throw new RuntimeException("\u8bf7\u914d\u7f6e\u5ba2\u6237\u7aef\u5206\u7ec4");
        }
        config.setGroup(motanClientGroup);
        config.setAccessLog(false);
        config.setRegistry(registryNames);
        config.setCheck(false);
        config.setRequestTimeout(requestTimeout);
        config.setThrowException(Boolean.valueOf(true));
        config.setDefault(true);
        return config;
    }
}

