/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoft.starter.motan.config;

import com.sinosoftgz.starter.utils.concurrent.ThreadPoolUtils;
import com.weibo.api.motan.closable.ShutDownHook;
import com.weibo.api.motan.util.MotanSwitcherUtil;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.filter.OncePerRequestFilter;

@Configuration
public class ShutDownHookConfiguration
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(ShutDownHookConfiguration.class);
    @Value(value="${management.context-path:}")
    private String managementContextPath;

    @Bean
    FilterRegistrationBean filterRegistrationBean() {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean((Filter)new OncePerRequestFilter(){

            protected void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
                filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                ShutDownHookConfiguration.this.closeResources();
            }
        }, new ServletRegistrationBean[0]);
        String shutdownUrl = "/shutdown";
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.managementContextPath})) {
            shutdownUrl = this.managementContextPath.endsWith("/") ? this.managementContextPath.substring(0, this.managementContextPath.length() - 1) + shutdownUrl : this.managementContextPath + shutdownUrl;
        }
        filterRegistrationBean.addUrlPatterns(new String[]{shutdownUrl});
        return filterRegistrationBean;
    }

    public void afterPropertiesSet() throws Exception {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                ShutDownHookConfiguration.this.closeResources();
            }
        });
    }

    public void closeResources() {
        try {
            MotanSwitcherUtil.setSwitcherValue((String)"feature.configserver.heartbeat", (boolean)false);
        }
        catch (Exception e) {
            log.error("\u5173\u95edmotan\u5f02\u5e38", (Throwable)e);
        }
        try {
            ShutDownHook.runHook((boolean)true);
            ThreadPoolUtils.shutdown();
        }
        catch (Exception e) {
            log.error("\u5173\u95edmotan\u5f02\u5e38", (Throwable)e);
        }
    }
}

