package com.sinosoft.starter.motan.config;

import com.weibo.api.motan.config.springsupport.AnnotationBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

/**
 * Created by Roney on 2020/12/1 17:15.
 */
@Configuration
public class MotanAnnotationPackageConfiguration {

    @Bean
    public AnnotationBean motanAnnotationBean(@Value("${motan.annotationPackage:}") String motanBeansPackage) {
        AnnotationBean motanAnnotationBean = new AnnotationBean();
        if (StringUtils.hasLength(motanBeansPackage)) {
            motanAnnotationBean.setPackage(motanBeansPackage);
        }
        if (motanAnnotationBean.getPackage() == null && !"close".equals(motanBeansPackage)) {
            throw new RuntimeException("请配置maton api 包");
        }
        return motanAnnotationBean;
    }
}
