package com.sinosoft.starter.motan.config;

import com.sinosoft.starter.motan.log.SinoLogService;
import com.sinosoft.starter.motan.properties.MotanProperties;
import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.config.springsupport.AnnotationBean;
import com.weibo.api.motan.config.springsupport.ProtocolConfigBean;
import com.weibo.api.motan.config.springsupport.RegistryConfigBean;
import com.weibo.api.motan.util.LoggerUtil;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * Created by Roney on 2019/8/20.
 *
 * @author Roney
 * @date 2019-08-20 20:36
 */
@EnableConfigurationProperties({MotanProperties.class})
@ImportAutoConfiguration(value = MotanAnnotationPackageConfiguration.class)
@Configuration
public class MotanCommonConfiguration {


    @Autowired
    private MotanProperties motanProperties;


    public MotanCommonConfiguration(final MotanProperties motanProperties) {
        this.motanProperties = motanProperties;
    }

    @Bean(name = "motan")
    public ProtocolConfigBean protocolConfig() {
        Integer maxWorkerThread = motanProperties.getWorkerThread().getMax();
        Integer minWorkerThread = motanProperties.getWorkerThread().getMin();
        Integer maxContentLength = motanProperties.getMaxContentLength();
        ProtocolConfigBean config = new ProtocolConfigBean();
        config.setDefault(true);
        config.setSerialization("hessian2Extension");
        config.setName("motan");
        config.setMaxContentLength(maxContentLength == null ? 10485760 : maxContentLength);
        config.setMaxWorkerThread(maxWorkerThread == null ? 200 : maxWorkerThread);
        config.setMinWorkerThread(minWorkerThread == null ? 20 : minWorkerThread);
        Map<String, String> parameters = new ConcurrentHashMap<>();
        parameters.put(URLParamType.endpointFactory.getName(), "eleganceMotan");
        config.setParameters(parameters);
        return config;
    }

    @Bean(name = "registry")
    public RegistryConfigBean registryConfig() {
        String zookeeperAddress = motanProperties.getRegistryCenter().getAddress();
        String regProtocol = motanProperties.getRegistryCenter().getRegProtocol();
        Integer connectTimeout = motanProperties.getRegistryCenter().getConnectTimeout();
        RegistryConfigBean config = new RegistryConfigBean();
        config.setDefault(true);
        config.setRegProtocol(regProtocol == null ? "commondZookeeper" : regProtocol);
        if (zookeeperAddress == null) {
            throw new RuntimeException("请配置zookeeper地址");
        }
        config.setAddress(zookeeperAddress);
        config.setConnectTimeout(connectTimeout == null ? 30000 : connectTimeout);
        return config;

    }

    @Bean
    SinoLogService sinoLogService() {
        Boolean logEnable = motanProperties.getLog().getEnable();
        SinoLogService sinoLogService = new SinoLogService(logEnable);
        LoggerUtil.setLogService(sinoLogService);
        return sinoLogService;
    }


}
