package com.sinosoft.starter.motan.config;

import com.sinosoft.starter.motan.properties.MotanProperties;
import com.weibo.api.motan.config.springsupport.BasicRefererConfigBean;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;


/**
 * Created by Roney on 2019/8/20.
 *
 * @author Roney
 * @date 2019-08-20 20:36
 */
@ImportAutoConfiguration(MotanCommonConfiguration.class)
@Configuration
public class MotanConsumerConfiguration {

    private MotanProperties motanProperties;

    public MotanConsumerConfiguration(final MotanProperties motanProperties) {
        this.motanProperties = motanProperties;
    }


    @Bean(name = "motanClientBasicConfig")
    public BasicRefererConfigBean baseRefererConfig() {
        return getBasicRefererConfigBean();
    }


    /**
     * 不进行重试的Motan客户端配置
     *
     * @return
     */
    @Bean(name = "motanClientFastFailConfig")
    public BasicRefererConfigBean motanClientFastFailConfig() {
        return getBasicRefererConfigBean();
    }


    private BasicRefererConfigBean getBasicRefererConfigBean() {
        String motanClientGroup = motanProperties.getConsumer().getGroup();
        Integer requestTimeout = motanProperties.getConsumer().getRequestTimeout();
        String protocolNames = motanProperties.getConsumer().getProtocolNames();
        String registryNames = motanProperties.getConsumer().getRegistryNames();
        BasicRefererConfigBean config = new BasicRefererConfigBean();
        config.setProtocol(protocolNames);
        if (motanClientGroup == null) {
            throw new RuntimeException("请配置客户端分组");
        } else {
            config.setGroup(motanClientGroup);
        }
        /**
         * 新版本统一不配置日志，如果需要查日志，请使用链路跟踪组件
         */
        config.setAccessLog(false);
        config.setRegistry(registryNames);
        config.setCheck(false);
        config.setRequestTimeout(requestTimeout);
        config.setThrowException(true);
        config.setDefault(true);
        return config;
    }

}
