package com.sinosoft.starter.motan.config;

import com.sinosoft.starter.motan.properties.MotanProperties;
import com.weibo.api.motan.config.springsupport.BasicServiceConfigBean;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;


/**
 * Created by Roney on 2019/8/20.
 *
 * @author Roney
 * @date 2019-08-20 20:36
 */
@ImportAutoConfiguration(MotanCommonConfiguration.class)
@Configuration
public class MotanProducerConfiguration {

    private MotanProperties motanProperties;

    public MotanProducerConfiguration(final MotanProperties motanProperties) {
        this.motanProperties = motanProperties;
    }

    /**
     * 基础服务端配置
     *
     * @return
     */
    @Bean(name = "motanServerBasicConfig")
    @ConditionalOnMissingBean
    public BasicServiceConfigBean baseServiceConfig() {
        Integer port = motanProperties.getProducer().getExportPort();
        String registryNames = motanProperties.getProducer().getRegistryNames();
        String motanServiceGroup = motanProperties.getProducer().getGroup();
        Integer requestTimeout = motanProperties.getProducer().getRequestTimeout();
        BasicServiceConfigBean config = new BasicServiceConfigBean();
        config.setDefault(true);
        if (port == null) {
            throw new RuntimeException("请配置motan端口");
        } else {
            config.setExport("motan:" + port);
        }
        if (motanServiceGroup == null) {
            throw new RuntimeException("请配置服务端分组");
        } else {
            config.setGroup(motanServiceGroup);
        }
        /**
         * 新版本统一不配置日志，如果需要查日志，请使用链路跟踪组件
         */
        config.setAccessLog(false);
        config.setShareChannel(true);
        config.setRequestTimeout(requestTimeout);
        config.setRegistry(registryNames);
        return config;
    }


}
