package com.sinosoft.starter.motan.config;

import com.sinosoftgz.starter.utils.concurrent.ThreadPoolUtils;
import com.weibo.api.motan.closable.ShutDownHook;
import com.weibo.api.motan.common.MotanConstants;
import com.weibo.api.motan.util.MotanSwitcherUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.filter.OncePerRequestFilter;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * Created by Roney on 2019/8/20.
 *
 * @author Roney
 * @date 2019-08-20 20:36
 */
@Configuration
@Slf4j
public class ShutDownHookConfiguration implements InitializingBean {
    @Value("${management.context-path:}")
    private String managementContextPath;

    @Bean
    FilterRegistrationBean filterRegistrationBean() {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean(new OncePerRequestFilter() {
            @Override
            protected void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
                filterChain.doFilter(httpServletRequest, httpServletResponse);
                closeResources();
            }
        });
        String shutdownUrl = "/shutdown";
        if (StringUtils.isNoneBlank(managementContextPath)) {
            shutdownUrl = managementContextPath.endsWith("/") ? managementContextPath.substring(0, managementContextPath.length() - 1) + shutdownUrl : managementContextPath + shutdownUrl;
        }
        filterRegistrationBean.addUrlPatterns(shutdownUrl);
        return filterRegistrationBean;
    }


    @Override
    public void afterPropertiesSet() throws Exception {
        Runtime.getRuntime().addShutdownHook(new Thread() {
            @Override
            public void run() {
                closeResources();
            }
        });
    }

    public void closeResources() {
        try {
            MotanSwitcherUtil.setSwitcherValue(MotanConstants.REGISTRY_HEARTBEAT_SWITCHER, false);
        } catch (Exception e) {
            log.error("关闭motan异常", e);
        }
        try {
            ShutDownHook.runHook(true);
            ThreadPoolUtils.shutdown();
        } catch (Exception e) {
            log.error("关闭motan异常", e);
        }
    }

}



