package com.sinosoft.starter.motan.log;

import com.weibo.api.motan.log.DefaultLogService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Created by Roney on 2019/8/20.
 * motan日志开关
 * 默认关闭motan日志开关
 *
 * @author Roney
 * @date 2019-08-20 20:36
 */
public class SinoLogService extends DefaultLogService {

    private static Logger info = LoggerFactory.getLogger("info");
    private static Logger access = LoggerFactory.getLogger("accessLog");
    private static Logger serviceStats = LoggerFactory.getLogger("serviceStatsLog");
    private static Logger profileLogger = LoggerFactory.getLogger("profile");

    private boolean infoEnabled;  //是否打印日志

    public SinoLogService(boolean infoEnabled) {
        this.infoEnabled = infoEnabled;
    }

    public void info(String msg) {
        if (infoEnabled) {
            info.info(msg);
        }
    }

    public void info(String format, Object... argArray) {
        if (infoEnabled) {
            info.info(format, argArray);
        }
    }

    public void info(String msg, Throwable t) {
        if (infoEnabled) {
            info.info(msg, t);
        }
    }

    public void accessLog(String msg) {
        if (infoEnabled) {
            access.info(msg);
        }
    }

    public void accessStatsLog(String msg) {
        if (infoEnabled) {
            serviceStats.info(msg);
        }
    }

    public void accessStatsLog(String format, Object... argArray) {
        if (infoEnabled) {
            serviceStats.info(format, argArray);
        }
    }

    public void accessProfileLog(String format, Object... argArray) {
        if (infoEnabled) {
            profileLogger.info(format, argArray);
        }
    }
}
