package com.sinosoft.starter.motan.properties;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

/**
 * Created by Roney on 2020/12/1 15:37.
 */
@ConfigurationProperties(prefix = "motan")
@Data
public class MotanProperties {


    public String annotationPackage;

    private Integer maxContentLength = 10485760;

    @NestedConfigurationProperty
    public WorkerThread workerThread = new WorkerThread();

    @NestedConfigurationProperty
    private RegistryCenter registryCenter = new RegistryCenter();

    @NestedConfigurationProperty
    private Consumer consumer = new Consumer();

    @NestedConfigurationProperty
    private Producer producer = new Producer();

    @NestedConfigurationProperty
    private Log log = new Log();

    @Data
    public class WorkerThread {
        private Integer max = 200;
        private Integer min = 20;
    }

    @Data
    public class RegistryCenter {
        private String type = "zookeeper";
        private String regProtocol = "commondZookeeper";
        private String address = "127.0.0.1:2181";
        private Integer port;
        private Integer connectTimeout = 300000;
    }

    @Data
    public class Consumer {
        private String protocolNames = "motan";
        private String registryNames = "registry";
        private String group = "sinosoftgz";
        private Integer requestTimeout = 60000;
    }

    @Data
    public class Producer {
        private Integer exportPort;
        private String registryNames = "registry";
        private String group = "sinosoftgz";
        private Integer requestTimeout = 60000;
    }

    @Data
    public class Log {
        private Boolean enable = false;
    }
}
