/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoft.starter.motan.config;

import com.sinosoft.starter.motan.config.MotanCommonConfiguration;
import com.sinosoft.starter.motan.properties.MotanProperties;
import com.weibo.api.motan.config.springsupport.BasicServiceConfigBean;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@ImportAutoConfiguration(value={MotanCommonConfiguration.class})
@Configuration
public class MotanProducerConfiguration {
    private MotanProperties motanProperties;

    public MotanProducerConfiguration(MotanProperties motanProperties) {
        this.motanProperties = motanProperties;
    }

    @Bean(name={"motanServerBasicConfig"})
    @ConditionalOnMissingBean
    public BasicServiceConfigBean baseServiceConfig() {
        Integer port = this.motanProperties.getProducer().getExportPort();
        String registryNames = this.motanProperties.getProducer().getRegistryNames();
        String motanServiceGroup = this.motanProperties.getProducer().getGroup();
        Integer requestTimeout = this.motanProperties.getProducer().getRequestTimeout();
        BasicServiceConfigBean config = new BasicServiceConfigBean();
        config.setDefault(true);
        if (port == null) {
            throw new RuntimeException("\u8bf7\u914d\u7f6emotan\u7aef\u53e3");
        }
        config.setExport("motan:" + port);
        if (motanServiceGroup == null) {
            throw new RuntimeException("\u8bf7\u914d\u7f6e\u670d\u52a1\u7aef\u5206\u7ec4");
        }
        config.setGroup(motanServiceGroup);
        config.setAccessLog(false);
        config.setShareChannel(Boolean.valueOf(true));
        config.setRequestTimeout(requestTimeout);
        config.setRegistry(registryNames);
        return config;
    }
}

