package com.weibo.api.motan.codec.extension;

import com.caucho.hessian.io.*;

import java.math.BigDecimal;


public class Hessian2ExtensionSerializerFactory extends SerializerFactory {

    @Override
    public Serializer getSerializer(Class cl) throws HessianProtocolException {

        //修复Hessian反序列化BigDecimal后值错误BUG
        if (BigDecimal.class.isAssignableFrom(cl)) {
            return new StringValueSerializer();
        }
        return super.getSerializer(cl);
    }

    @Override
    public Deserializer getDeserializer(Class cl) throws HessianProtocolException {
        //修复Hessian反序列化BigDecimal后值错误BUG
        if (BigDecimal.class.isAssignableFrom(cl)) {
            return new BigDecimalDeserializer();
        }
        return super.getDeserializer(cl);
    }
}
