/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.sample.program.jpa.biz.impl;

import com.sinosoftgz.global.common.request.page.PageQueryRequest;
import com.sinosoftgz.global.common.response.enums.CommonResponseCodeEnum;
import com.sinosoftgz.global.common.response.page.ResultPage;
import com.sinosoftgz.sample.program.jpa.biz.DemoBiz;
import com.sinosoftgz.sample.program.jpa.dto.DemoDTO;
import com.sinosoftgz.sample.program.jpa.mapping.DemoDTOMapping;
import com.sinosoftgz.sample.program.jpa.request.DemoReq;
import com.sinosoftgz.sample.program.jpa.response.DemoResp;
import com.sinosoftgz.sample.program.jpa.service.IDemoService;
import com.sinosoftgz.sample.program.jpa.vo.DemoVO;
import com.sinosoftgz.starter.exception.biz.ArgumentNotValidException;
import com.sinosoftgz.starter.exception.biz.BusinessException;
import com.sinosoftgz.starter.utils.lang.Lang;
import com.sinosoftgz.starter.validation.utils.ValidationUtils;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class DemoBizImpl
implements DemoBiz {
    private static final Logger log = LoggerFactory.getLogger(DemoBizImpl.class);
    @Autowired
    IDemoService demoService;
    @Resource
    DemoDTOMapping demoDTOMapping;

    @Override
    public DemoDTO prepareAddDemoDTO(DemoDTO demoDTO) {
        return this.addDemoDTO(demoDTO);
    }

    @Override
    public DemoDTO addDemoDTO(DemoDTO demoDTO) {
        Assert.notNull((Object)((Object)demoDTO), (String)"Object must be have value!");
        return this.demoService.addDemoDTO(demoDTO);
    }

    @Override
    public List<DemoDTO> batchAddDemoDTO(List<DemoDTO> demoDTOs) {
        Assert.notNull(demoDTOs, (String)"Object must be have value!");
        return this.demoService.batchAddDemoDTO(demoDTOs);
    }

    @Override
    public DemoDTO prepareUpdateDemoDTO(DemoDTO demoDTO) {
        return this.prepareAddDemoDTO(demoDTO);
    }

    @Override
    public DemoDTO updateDemoDTO(DemoDTO demoDTO) {
        return this.addDemoDTO(demoDTO);
    }

    @Override
    public List<DemoDTO> batchUpdateDemoDTO(List<DemoDTO> demoDTOs) {
        return this.batchAddDemoDTO(demoDTOs);
    }

    @Override
    public int deleteById(String id) {
        return this.demoService.deleteById(id);
    }

    @Override
    public int deleteByIds(List<String> ids) {
        return this.demoService.deleteByIds(ids);
    }

    @Override
    public int deleteDemoDTO(DemoDTO demoDTO) {
        return this.demoService.deleteDemoDTO(demoDTO);
    }

    @Override
    public int batchDeleteDemoDTO(List<DemoDTO> demoDTOs) {
        return this.demoService.batchDeleteDemoDTO(demoDTOs);
    }

    @Override
    public DemoDTO viewDemoDTO(String id) {
        return this.findById(id);
    }

    @Override
    public List<DemoDTO> prepareFindDemoDTO(DemoDTO demoDTO) {
        return this.findDemoDTO(demoDTO);
    }

    @Override
    public List<DemoDTO> findDemoDTO(DemoDTO demoDTO) {
        return this.demoService.findDemoDTO(demoDTO);
    }

    @Override
    public DemoDTO findById(String id) {
        Assert.notNull((Object)id, (String)"id must have value");
        return this.demoService.findById(id);
    }

    @Override
    public List<DemoDTO> findByIds(List<String> ids) {
        Assert.notNull(ids, (String)"ids must have value");
        return this.demoService.findByIds(ids);
    }

    @Override
    public ResultPage<DemoDTO> findDemoDTOPage(PageQueryRequest pageQueryRequest) {
        return this.demoService.findDemoDTOPage(pageQueryRequest);
    }

    @Override
    public DemoResp complexAddDemo(DemoReq demoReq) {
        ValidationUtils.ValidResult validResult = ValidationUtils.validateBean((Object)demoReq, (Class[])new Class[0]);
        if (validResult.hasErrors()) {
            throw new ArgumentNotValidException(validResult.getErrors());
        }
        DemoVO demoVO = demoReq.getDemoVO();
        DemoDTO demoDTO = this.addDemoDTO((DemoDTO)((Object)this.demoDTOMapping.targetToSource((Object)demoVO)));
        List<DemoVO> demoVOList = demoReq.getDemoVOList();
        List<DemoDTO> demoDTOList = this.batchAddDemoDTO(this.demoDTOMapping.targetToSource(demoVOList));
        if (Lang.isEmpty(demoDTOList)) {
            throw new BusinessException(CommonResponseCodeEnum.DATA_NO_EMPTY_ERROR.getResultCode(), String.format(CommonResponseCodeEnum.DATA_NO_EMPTY_ERROR.getResultMsg(), "demoDTOList"));
        }
        DemoResp demoResp = new DemoResp((DemoVO)((Object)this.demoDTOMapping.sourceToTarget((Object)demoDTO)), this.demoDTOMapping.sourceToTarget(demoDTOList), "");
        return demoResp;
    }
}

