/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.sample.program.jpa.controller;

import com.sinosoftgz.global.common.request.page.PageQueryRequest;
import com.sinosoftgz.global.common.response.BaseResponse;
import com.sinosoftgz.global.common.response.page.ResultPage;
import com.sinosoftgz.sample.program.jpa.biz.DemoBiz;
import com.sinosoftgz.sample.program.jpa.dto.DemoDTO;
import com.sinosoftgz.sample.program.jpa.mapping.DemoDTOMapping;
import com.sinosoftgz.sample.program.jpa.request.DemoReq;
import com.sinosoftgz.sample.program.jpa.request.query.DemoQueryReq;
import com.sinosoftgz.sample.program.jpa.response.DemoResp;
import com.sinosoftgz.sample.program.jpa.response.query.DemoQueryResp;
import com.sinosoftgz.sample.program.jpa.vo.DemoVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"DemoController"})
@RestController
@RequestMapping(value={"/activity/demo"})
public class DemoController {
    private static final Logger log = LoggerFactory.getLogger(DemoController.class);
    @Autowired
    DemoBiz demoBiz;
    @Resource
    DemoDTOMapping demoDTOMapping;

    @PostMapping(value={"simpleAdd"})
    @ApiOperation(value="\u6837\u4f8b\u7a0b\u5e8f\u7b80\u5355\u589e\u52a0")
    @ApiImplicitParams(value={@ApiImplicitParam(name="demoVO", value="\u6837\u4f8b\u7a0b\u5e8fVO\u8bf7\u6c42\u5bf9\u8c61", dataType="DemoVO", required=true)})
    public BaseResponse<DemoResp> simpleAddDemo(@Valid @RequestBody DemoVO demoVO) {
        return this.addDemo(demoVO);
    }

    @PostMapping(value={"complexAdd"})
    @ApiOperation(value="\u6837\u4f8b\u7a0b\u5e8f\u590d\u6742\u589e\u52a0")
    @ApiImplicitParams(value={@ApiImplicitParam(name="demoReq", value="\u6837\u4f8b\u7a0b\u5e8f\u8bf7\u6c42\u5bf9\u8c61", dataType="DemoReq", required=true)})
    public BaseResponse<DemoResp> complexAddDemo(@Valid @RequestBody DemoReq demoReq) {
        DemoResp DemoResp2 = this.demoBiz.complexAddDemo(demoReq);
        return BaseResponse.ok((Object)DemoResp2);
    }

    @PostMapping(value={"add"})
    @ApiOperation(value="\u6837\u4f8b\u7a0b\u5e8f\u589e\u52a0")
    @ApiImplicitParams(value={@ApiImplicitParam(name="demoVO", value="\u6837\u4f8b\u7a0b\u5e8fVO\u8bf7\u6c42\u5bf9\u8c61", dataType="DemoVO", required=true)})
    public BaseResponse<DemoResp> addDemo(@Valid @RequestBody DemoVO demoVO) {
        DemoDTO DemoDTO2 = this.demoBiz.addDemoDTO((DemoDTO)((Object)this.demoDTOMapping.targetToSource((Object)demoVO)));
        DemoResp DemoResp2 = new DemoResp();
        DemoResp2.setDemoVO((DemoVO)((Object)this.demoDTOMapping.sourceToTarget((Object)DemoDTO2)));
        return BaseResponse.ok((Object)DemoResp2);
    }

    @PostMapping(value={"update"})
    @ApiOperation(value="\u6837\u4f8b\u7a0b\u5e8f\u4fee\u6539")
    @ApiImplicitParams(value={@ApiImplicitParam(name="demoVO", value="\u6837\u4f8b\u7a0b\u5e8fVO\u8bf7\u6c42\u5bf9\u8c61", dataType="DemoVO", required=true)})
    public BaseResponse<DemoResp> updateDemo(@Valid @RequestBody DemoVO demoVO) {
        DemoDTO DemoDTO2 = this.demoBiz.updateDemoDTO((DemoDTO)((Object)this.demoDTOMapping.targetToSource((Object)demoVO)));
        DemoResp DemoResp2 = new DemoResp();
        DemoResp2.setDemoVO((DemoVO)((Object)this.demoDTOMapping.sourceToTarget((Object)DemoDTO2)));
        return BaseResponse.ok((Object)DemoResp2);
    }

    @PostMapping(value={"find"})
    @ApiOperation(value="\u6837\u4f8b\u7a0b\u5e8f\u67e5\u8be2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="DemoQueryReq", value="\u6837\u4f8b\u7a0b\u5e8f\u67e5\u8be2\u8bf7\u6c42\u5bf9\u8c61", dataType="DemoQueryReq", required=true)})
    public BaseResponse<DemoQueryResp> findDemo(@Valid @RequestBody DemoQueryReq demoQueryReq) {
        List<DemoDTO> DemoDTOList = this.demoBiz.findDemoDTO((DemoDTO)((Object)this.demoDTOMapping.targetToSource((Object)demoQueryReq.getDemoVO())));
        DemoQueryResp DemoQueryResp2 = new DemoQueryResp();
        DemoQueryResp2.setDemoVOList(this.demoDTOMapping.sourceToTarget(DemoDTOList));
        return BaseResponse.ok((Object)DemoQueryResp2);
    }

    @PostMapping(value={"findById"})
    @ApiOperation(value="\u6837\u4f8b\u7a0b\u5e8f\u6839\u636eID\u67e5\u8be2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="id", dataType="String", defaultValue="0", required=true)})
    public BaseResponse<DemoResp> findById(@RequestParam(value="id") String id) {
        DemoDTO DemoDTO2 = this.demoBiz.findById(id);
        DemoResp DemoResp2 = new DemoResp();
        DemoResp2.setDemoVO((DemoVO)((Object)this.demoDTOMapping.sourceToTarget((Object)DemoDTO2)));
        return BaseResponse.ok((Object)DemoResp2);
    }

    @PostMapping(value={"deleteById"})
    @ApiOperation(value="\u6837\u4f8b\u7a0b\u5e8f\u6839\u636eid\u5220\u9664")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="id", dataType="String", defaultValue="0", required=true)})
    public BaseResponse<DemoResp> deleteById(@RequestParam(value="id") String id) {
        int deleteSize = this.demoBiz.deleteById(id);
        if (deleteSize > 0) {
            return BaseResponse.ok();
        }
        return BaseResponse.error((String)"\u5220\u9664\u5931\u8d25");
    }

    @PostMapping(value={"findByPage"})
    @ApiOperation(value="\u6837\u4f8b\u7a0b\u5e8f\u5206\u9875\u67e5\u8be2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageQueryRequest", value="\u6837\u4f8b\u7a0b\u5e8f\u5206\u9875\u8bf7\u6c42\u5bf9\u8c61", dataType="PageQueryRequest", required=true)})
    public BaseResponse<ResultPage<DemoDTO>> findByPage(@RequestBody PageQueryRequest pageQueryRequest) {
        ResultPage<DemoDTO> resultPage = this.demoBiz.findDemoDTOPage(pageQueryRequest);
        return BaseResponse.ok(resultPage);
    }

    @PostMapping(value={"findByPageVO"})
    @ApiOperation(value="\u6837\u4f8b\u7a0b\u5e8f\u5206\u9875\u67e5\u8be2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageQueryRequest", value="\u6837\u4f8b\u7a0b\u5e8f\u5206\u9875\u8bf7\u6c42\u5bf9\u8c61", dataType="PageQueryRequest", required=true)})
    public BaseResponse<ResultPage<DemoVO>> findByPageDemoVO(@RequestBody PageQueryRequest pageQueryRequest) {
        ResultPage<DemoDTO> resultPage = this.demoBiz.findDemoDTOPage(pageQueryRequest);
        return BaseResponse.ok((Object)this.demoDTOMapping.sourceToTarget(resultPage));
    }
}

