/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.sample.program.jpa.service.impl;

import com.sinosoftgz.global.common.request.page.PageQueryRequest;
import com.sinosoftgz.global.common.response.page.ResultPage;
import com.sinosoftgz.sample.program.jpa.domain.Demo;
import com.sinosoftgz.sample.program.jpa.dto.DemoDTO;
import com.sinosoftgz.sample.program.jpa.mapping.DemoMapping;
import com.sinosoftgz.sample.program.jpa.repository.DemoRepos;
import com.sinosoftgz.sample.program.jpa.service.IDemoService;
import com.sinosoftgz.sample.program.jpa.specification.DemoSpecification;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class DemoServiceImpl
implements IDemoService {
    private static final Logger log = LoggerFactory.getLogger(DemoServiceImpl.class);
    @Autowired
    DemoRepos demoRepos;
    @Resource
    DemoMapping demoMapping;

    @Override
    public DemoDTO prepareAddDemoDTO(DemoDTO demoDTO) {
        return this.addDemoDTO(demoDTO);
    }

    @Override
    public DemoDTO addDemoDTO(DemoDTO demoDTO) {
        Assert.notNull((Object)((Object)demoDTO), (String)"Object must be have value!");
        Demo demo = this.targetToSource(demoDTO);
        return this.sourceToTarget((Demo)((Object)this.demoRepos.save((Object)demo)));
    }

    @Override
    public List<DemoDTO> batchAddDemoDTO(List<DemoDTO> demoDTOs) {
        Assert.notNull(demoDTOs, (String)"Object must be have value!");
        List<Demo> demos = this.targetToSource(demoDTOs);
        return this.sourceToTarget(this.demoRepos.save(demos));
    }

    @Override
    public DemoDTO prepareUpdateDemoDTO(DemoDTO demoDTO) {
        return this.addDemoDTO(demoDTO);
    }

    @Override
    public DemoDTO updateDemoDTO(DemoDTO demoDTO) {
        return this.addDemoDTO(demoDTO);
    }

    @Override
    public List<DemoDTO> batchUpdateDemoDTO(List<DemoDTO> demoDTOs) {
        return this.batchAddDemoDTO(demoDTOs);
    }

    @Override
    public int deleteById(String id) {
        Assert.notNull((Object)id, (String)"id must have value");
        try {
            this.demoRepos.delete((Serializable)((Object)id));
            return 1;
        }
        catch (Exception e) {
            log.error("error : ", (Throwable)e);
            return 0;
        }
    }

    @Override
    public int deleteByIds(List<String> ids) {
        Assert.notNull(ids, (String)"ids must have value");
        List<DemoDTO> demoDTOs = this.findByIds(ids);
        return this.batchDeleteDemoDTO(demoDTOs);
    }

    @Override
    public int deleteDemoDTO(DemoDTO demoDTO) {
        Assert.notNull((Object)((Object)demoDTO), (String)"Object must be have value!");
        Demo demo = this.targetToSource(demoDTO);
        try {
            this.demoRepos.delete((Object)demo);
            return 1;
        }
        catch (Exception e) {
            log.error("error : ", (Throwable)e);
            return 0;
        }
    }

    @Override
    public int batchDeleteDemoDTO(List<DemoDTO> demoDTOs) {
        Assert.notNull(demoDTOs, (String)"Object must be have value!");
        List<Demo> demos = this.targetToSource(demoDTOs);
        try {
            this.demoRepos.deleteInBatch(demos);
            return demos.size();
        }
        catch (Exception e) {
            log.error("error : ", (Throwable)e);
            return 0;
        }
    }

    @Override
    public DemoDTO viewDemoDTO(String id) {
        return this.findById(id);
    }

    @Override
    public List<DemoDTO> prepareFindDemoDTO(DemoDTO demoDTO) {
        return this.findDemoDTO(demoDTO);
    }

    @Override
    public List<DemoDTO> findDemoDTO(DemoDTO demoDTO) {
        Demo demo = this.targetToSource(demoDTO);
        DemoSpecification querySpecification = new DemoSpecification(demo);
        return this.demoRepos.findAll(querySpecification);
    }

    @Override
    public DemoDTO findById(String id) {
        Assert.notNull((Object)id, (String)"id must have value");
        return this.sourceToTarget((Demo)((Object)this.demoRepos.findOne((Serializable)((Object)id))));
    }

    @Override
    public List<DemoDTO> findByIds(List<String> ids) {
        Assert.notNull(ids, (String)"ids must have value");
        return this.sourceToTarget(this.demoRepos.findAll(ids));
    }

    @Override
    public ResultPage<DemoDTO> findDemoDTOPage(PageQueryRequest pageQueryRequest) {
        DemoDTO demoDTO = (DemoDTO)((Object)pageQueryRequest.getEntity());
        Demo demo = this.targetToSource(demoDTO);
        Pageable pageable = PageQueryRequest.convertToPageable((PageQueryRequest)pageQueryRequest);
        DemoSpecification querySpecification = new DemoSpecification(demo);
        return this.demoMapping.mapPage(this.demoRepos.findAll(querySpecification, pageable));
    }

    private Demo targetToSource(DemoDTO demoDTO) {
        return (Demo)((Object)this.demoMapping.targetToSource((Object)demoDTO));
    }

    private DemoDTO sourceToTarget(Demo demo) {
        return (DemoDTO)((Object)this.demoMapping.sourceToTarget((Object)demo));
    }

    private List<Demo> targetToSource(List<DemoDTO> demoDTOs) {
        return this.demoMapping.targetToSource(demoDTOs);
    }

    private List<DemoDTO> sourceToTarget(List<Demo> demos) {
        return this.demoMapping.sourceToTarget(demos);
    }
}

