/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.scheduler.xxl.job.config;

import com.sinosoftgz.starter.scheduler.xxl.job.properties.XxlJobProperties;
import com.xxl.job.core.executor.impl.XxlJobSpringExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@EnableConfigurationProperties(value={XxlJobProperties.class})
@Import(value={})
@ConditionalOnProperty(prefix="xxl.job", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class XxlJobConfiguration {
    private static final Logger log = LoggerFactory.getLogger(XxlJobConfiguration.class);
    @Autowired
    XxlJobProperties xxlJobProperties;

    @Bean
    public XxlJobSpringExecutor xxlJobExecutor() {
        log.info(">>>>>>>>>>> xxl-job config init.");
        String adminAddresses = this.xxlJobProperties.getAdminAddresses();
        String accessToken = this.xxlJobProperties.getAccessToken();
        XxlJobProperties.Executor executor = this.xxlJobProperties.getExecutor();
        String appname = executor.getAppName();
        String address = executor.getAddress();
        String ip = executor.getIp();
        int port = executor.getPort();
        String logPath = executor.getLogPath();
        int logRetentionDays = executor.getLogRetentionDays();
        XxlJobSpringExecutor xxlJobSpringExecutor = new XxlJobSpringExecutor();
        xxlJobSpringExecutor.setAdminAddresses(adminAddresses);
        xxlJobSpringExecutor.setAppname(appname);
        xxlJobSpringExecutor.setAddress(address);
        xxlJobSpringExecutor.setIp(ip);
        xxlJobSpringExecutor.setPort(port);
        xxlJobSpringExecutor.setAccessToken(accessToken);
        xxlJobSpringExecutor.setLogPath(logPath);
        xxlJobSpringExecutor.setLogRetentionDays(logRetentionDays);
        return xxlJobSpringExecutor;
    }
}

