package com.sinosoftgz.starter.scheduler.xxl.job.config;


import com.sinosoftgz.starter.scheduler.xxl.job.properties.XxlJobProperties;
import com.xxl.job.core.executor.impl.XxlJobSpringExecutor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

/**
 * Created by Roney on 2020/9/11 13:42.
 */

@Configuration
@Slf4j
@EnableConfigurationProperties({XxlJobProperties.class})
@Import({
})
@ConditionalOnProperty(prefix = XxlJobProperties.XXL_JOB_PREFIX, name = "enabled", havingValue = "true", matchIfMissing = true)
public class XxlJobConfiguration {

    @Autowired
    XxlJobProperties xxlJobProperties;

    @Bean
    public XxlJobSpringExecutor xxlJobExecutor() {
        log.info(">>>>>>>>>>> xxl-job config init.");
        String adminAddresses = xxlJobProperties.getAdminAddresses();
        String accessToken = xxlJobProperties.getAccessToken();
        XxlJobProperties.Executor executor = xxlJobProperties.getExecutor();
        String appname = executor.getAppName();
        String address = executor.getAddress();
        String ip = executor.getIp();
        int port = executor.getPort();
        String logPath = executor.getLogPath();
        int logRetentionDays = executor.getLogRetentionDays();

        XxlJobSpringExecutor xxlJobSpringExecutor = new XxlJobSpringExecutor();
        xxlJobSpringExecutor.setAdminAddresses(adminAddresses);
        xxlJobSpringExecutor.setAppname(appname);
        xxlJobSpringExecutor.setAddress(address);
        xxlJobSpringExecutor.setIp(ip);
        xxlJobSpringExecutor.setPort(port);
        xxlJobSpringExecutor.setAccessToken(accessToken);
        xxlJobSpringExecutor.setLogPath(logPath);
        xxlJobSpringExecutor.setLogRetentionDays(logRetentionDays);

        return xxlJobSpringExecutor;
    }

    /**
     * 针对多网卡、容器内部署等情况，可借助 "spring-cloud-commons" 提供的 "InetUtils" 组件灵活定制注册IP；
     *
     *      1、引入依赖：
     *          <dependency>
     *             <groupId>org.springframework.cloud</groupId>
     *             <artifactId>spring-cloud-commons</artifactId>
     *             <version>${version}</version>
     *         </dependency>
     *
     *      2、配置文件，或者容器启动变量
     *          spring.cloud.inetutils.preferred-networks: 'xxx.xxx.xxx.'
     *
     *      3、获取IP
     *          String ip_ = inetUtils.findFirstNonLoopbackHostInfo().getIpAddress();
     */


}