package com.sinosoftgz.starter.scheduler.xxl.job.properties;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

/**
 * @author: Roney
 * @date: 2021-10-14 15:33
 * @description: XxlJob Properties
 */
@ConfigurationProperties(prefix = XxlJobProperties.XXL_JOB_PREFIX)
@Data
public class XxlJobProperties {

    public static final String XXL_JOB_PREFIX = "xxl.job";

    /**
     * 是否开启
     * 默认开启
     */
    private boolean enabled = true;

    /**
     * 服务端地址
     */
    private String adminAddresses;

    /**
     * 访问token
     */
    private String accessToken;

    /**
     * Executor 配置信息
     */
    @NestedConfigurationProperty
    private Executor executor = new Executor();

    @Data
    public static class Executor {

        private String appName;

        private String address;

        private String ip;

        private int port;

        private String logPath;

        private int logRetentionDays;
    }
}
