/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.custom.security.config;

import com.sinosoftgz.starter.custom.security.properties.CorsProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;

@Configuration
@ConditionalOnProperty(prefix="cors", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={CorsProperties.class})
public class CorsConfiguration {
    private static final Logger log = LoggerFactory.getLogger(CorsConfiguration.class);
    @Autowired
    CorsProperties corsProperties;

    @Bean
    public CorsFilter corsFilter() {
        log.info("start to config using :{}", (Object)this.corsProperties);
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        org.springframework.web.cors.CorsConfiguration config = new org.springframework.web.cors.CorsConfiguration();
        config.setAllowCredentials(this.corsProperties.getAllowCredentials());
        config.addAllowedOrigin(this.corsProperties.getAllowedOrigin());
        config.addAllowedHeader(this.corsProperties.getAllowedHeader());
        config.addAllowedMethod(this.corsProperties.getAllowedMethod());
        if (this.corsProperties.getConfigPath() != null && this.corsProperties.getConfigPath().length > 0) {
            for (String path : this.corsProperties.getConfigPath()) {
                source.registerCorsConfiguration(path, config);
            }
        }
        return new CorsFilter((CorsConfigurationSource)source);
    }
}

