/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.custom.security.config;

import com.sinosoftgz.starter.custom.security.filter.ActuatorIpWhiteFilter;
import com.sinosoftgz.starter.custom.security.filter.InjectionAttackFilter;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={})
public class CustomSecurityConfiguration {
    @Value(value="${management.context-path:/actuator}")
    private String managementContextPath;
    @Value(value="${actuator.whitelist:127.0.0.1}")
    private String[] actuatorIpWhitelist;
    @Value(value="${injection.attack.intercept.urls:/*}")
    private List<String> injectionAttackUrls;

    @Bean
    @ConditionalOnProperty(name={"actuator.enabled"}, havingValue="true", matchIfMissing=true)
    FilterRegistrationBean actuatorIpWhiteFilter() {
        ActuatorIpWhiteFilter filter = new ActuatorIpWhiteFilter();
        filter.setActuatorIpWhitelist(this.actuatorIpWhitelist);
        filter.setManagementContextPath(this.managementContextPath);
        FilterRegistrationBean registrationBean = new FilterRegistrationBean((Filter)filter, new ServletRegistrationBean[0]);
        ArrayList<String> urls = new ArrayList<String>();
        urls.add(this.managementContextPath + "/*");
        registrationBean.setUrlPatterns(urls);
        registrationBean.setOrder(1);
        return registrationBean;
    }

    @Bean
    @ConditionalOnProperty(name={"injection.attack.intercept.enabled"}, havingValue="true", matchIfMissing=true)
    FilterRegistrationBean injectionAttackFilter() {
        InjectionAttackFilter filter = new InjectionAttackFilter();
        filter.setFilterXSS(true);
        filter.setFilterSQL(true);
        filter.setClickJacking(true);
        FilterRegistrationBean registrationBean = new FilterRegistrationBean((Filter)filter, new ServletRegistrationBean[0]);
        registrationBean.setUrlPatterns(this.injectionAttackUrls);
        registrationBean.setOrder(-1);
        return registrationBean;
    }
}

