/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.custom.security.filter;

import com.sinosoftgz.starter.utils.web.WebUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActuatorIpWhiteFilter
implements Filter {
    private Logger log = LoggerFactory.getLogger(ActuatorIpWhiteFilter.class);
    private String[] actuatorIpWhitelist;
    private String managementContextPath;

    public String[] getActuatorIpWhitelist() {
        return this.actuatorIpWhitelist;
    }

    public void setActuatorIpWhitelist(String[] actuatorIpWhitelist) {
        this.actuatorIpWhitelist = actuatorIpWhitelist;
    }

    public String getManagementContextPath() {
        return this.managementContextPath;
    }

    public void setManagementContextPath(String managementContextPath) {
        this.managementContextPath = managementContextPath;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String ip = WebUtils.getIp((HttpServletRequest)request);
        String requestUrl = request.getRequestURI();
        if (!this.isMatchWhiteList(ip) && requestUrl.contains(this.managementContextPath)) {
            response.setContentType("application/json");
            response.setCharacterEncoding("UTF-8");
            PrintWriter writer = response.getWriter();
            writer.write("{\"code\":401}");
            writer.flush();
            writer.close();
            return;
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void destroy() {
    }

    private boolean isMatchWhiteList(String ip) {
        List<String> list = Arrays.asList(this.actuatorIpWhitelist);
        return list.stream().anyMatch(item -> ip.startsWith((String)item));
    }
}

