package com.sinosoftgz.starter.custom.security.config;

import com.sinosoftgz.starter.custom.security.filter.ActuatorIpWhiteFilter;
import com.sinosoftgz.starter.custom.security.filter.InjectionAttackFilter;
import com.sinosoftgz.starter.custom.security.properties.CorsProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;

import java.util.ArrayList;
import java.util.List;

@Configuration
@Import({

})

public class CustomSecurityConfiguration {
    @Value("${management.context-path:/actuator}")
    private String managementContextPath;

    @Value("${actuator.whitelist:127.0.0.1}")
    private String[] actuatorIpWhitelist;

    @Value("${injection.attack.intercept.urls:/*}")
    private List<String> injectionAttackUrls;

    /**
     * 监控拦截
     *
     * @return
     */
    @Bean
    @ConditionalOnProperty(name = "actuator.enabled", havingValue = "true", matchIfMissing = true)
    FilterRegistrationBean actuatorIpWhiteFilter() {
        ActuatorIpWhiteFilter filter = new ActuatorIpWhiteFilter();
        filter.setActuatorIpWhitelist(actuatorIpWhitelist);
        filter.setManagementContextPath(managementContextPath);
        FilterRegistrationBean registrationBean = new FilterRegistrationBean(filter);
        List<String> urls = new ArrayList<>();
        urls.add(managementContextPath + "/*");
        registrationBean.setUrlPatterns(urls);
        registrationBean.setOrder(1);
        return registrationBean;
    }

    /**
     * 注入攻击拦截
     *
     * @return
     */
    @Bean
    @ConditionalOnProperty(name = "injection.attack.intercept.enabled", havingValue = "true", matchIfMissing = true)
    FilterRegistrationBean injectionAttackFilter() {
        InjectionAttackFilter filter = new InjectionAttackFilter();
        filter.setFilterXSS(true);
        filter.setFilterSQL(true);
        filter.setClickJacking(true);
        FilterRegistrationBean registrationBean = new FilterRegistrationBean(filter);
        registrationBean.setUrlPatterns(injectionAttackUrls);
        registrationBean.setOrder(-1);
        return registrationBean;
    }

}
