package com.sinosoftgz.starter.custom.security.filter;


import com.sinosoftgz.starter.utils.web.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;


public class ActuatorIpWhiteFilter implements Filter {
    private Logger log = LoggerFactory.getLogger(ActuatorIpWhiteFilter.class);

    private String[] actuatorIpWhitelist;

    private String managementContextPath;

    public String[] getActuatorIpWhitelist() {
        return actuatorIpWhitelist;
    }

    public void setActuatorIpWhitelist(String[] actuatorIpWhitelist) {
        this.actuatorIpWhitelist = actuatorIpWhitelist;
    }

    public String getManagementContextPath() {
        return managementContextPath;
    }

    public void setManagementContextPath(String managementContextPath) {
        this.managementContextPath = managementContextPath;
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest) servletRequest;
        HttpServletResponse response = (HttpServletResponse) servletResponse;
        String ip = WebUtils.getIp(request);
        String requestUrl = request.getRequestURI();
        // log.info("访问的url为：{}，访问{}的机器的原始IP：{};", requestUrl, requestUrl, ip);

        if (!isMatchWhiteList(ip) && requestUrl.contains(managementContextPath)) {
            response.setContentType("application/json");
            response.setCharacterEncoding("UTF-8");
            PrintWriter writer = response.getWriter();
            writer.write("{\"code\":401}");
            writer.flush();
            writer.close();
            return;
        }

        filterChain.doFilter(request, response);
    }

    @Override
    public void destroy() {
    }

    /**
     * 匹配是否是白名单
     *
     * @param ip
     * @return
     */
    private boolean isMatchWhiteList(String ip) {
        List<String> list = Arrays.asList(actuatorIpWhitelist);
        return list.stream().anyMatch(item -> ip.startsWith(item));
    }


}
