package com.sinosoftgz.starter.custom.security.properties;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.io.Serializable;

@ConfigurationProperties(prefix = CorsProperties.CORS_PREFIX)
@Data
public class CorsProperties implements Serializable {

    public static final String CORS_PREFIX = "cors";

    /**
     * 是否开启
     * 默认开启
     */
    private boolean enabled = true;

    private Boolean allowCredentials = Boolean.TRUE;

    private String allowedOrigin = "*";

    private String allowedHeader = "*";

    private String allowedMethod = "*";

    private String[] configPath = {"/api/**"};


}
