package com.sinosoftgz.starter.encrypt.api;


import com.sinosoftgz.global.common.response.BaseResponse;
import com.sinosoftgz.starter.encrypt.properties.EncryptProperties;
import com.sinosoftgz.starter.encrypt.vo.RSAVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * Created by Roney on 2021/1/4 10:58.
 * 获取相关的加密key信息
 */
@RestController
@RequestMapping({"/encrypt"})
public class EncryptKeyController {
    @Autowired
    private EncryptProperties encryptProperties;

    @GetMapping({"/aesKey"})
    public BaseResponse aesKey() {
        return BaseResponse.ok(encryptProperties.getAesConfig().getKey());
    }

    @GetMapping({"/desKey"})
    public BaseResponse desKey() {
        return BaseResponse.ok(encryptProperties.getDesConfig().getKey());
    }

    @GetMapping({"/rsaKey"})
    public BaseResponse rsaKey() {
        return BaseResponse.ok(new RSAVO(encryptProperties.getRsaConfig().getPrivateKey(), encryptProperties.getRsaConfig().getPublicKey()));
    }

}
