package com.sinosoftgz.starter.encrypt.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sinosoftgz.starter.encrypt.advice.DecryptRequestBodyAdvice;
import com.sinosoftgz.starter.encrypt.advice.EncryptResponseBodyAdvice;
import com.sinosoftgz.starter.encrypt.api.EncryptKeyController;
import com.sinosoftgz.starter.encrypt.properties.EncryptProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

/**
 * Created by Roney on 2020/12/25 16:19.
 */
@Configuration
@EnableConfigurationProperties({EncryptProperties.class})
@Import({
        EncryptKeyController.class
})
@ConditionalOnProperty(value = "encrypt.enable", havingValue = "true", matchIfMissing = true)
public class EncryptConfiguration {

    private EncryptProperties encryptProperties;

    private ObjectMapper objectMapper;

    public EncryptConfiguration(final EncryptProperties encryptProperties, final ObjectMapper objectMapper) {
        this.encryptProperties = encryptProperties;
        this.objectMapper = objectMapper;
    }

    /**
     * 配置请求解密
     *
     * @return
     */
    @Bean
    public EncryptResponseBodyAdvice encryptResponseBodyAdvice() {
        return new EncryptResponseBodyAdvice(objectMapper, encryptProperties);
    }

    /**
     * 配置请求加密
     *
     * @return
     */
    @Bean
    public DecryptRequestBodyAdvice decryptRequestBodyAdvice() {
        return new DecryptRequestBodyAdvice(encryptProperties);
    }

}
