package com.sinosoftgz.starter.encrypt.properties;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;

/**
 * <p>加密数据配置读取类</p>
 * <p>在SpringBoot项目中的application.yml中添加配置信息即可</p>
 * <pre>
 *     encrypt:
 *      body:
 *       aes-key: 12345678 # AES加密秘钥
 *       des-key: 12345678 # DES加密秘钥
 *       rsa-private-key: rsa的私钥
 *       rsa-publicKey: rsa的公钥
 *       rsa-open: 是否打开
 *       rsa-showLog: 是否打印日志
 * </pre>
 * <p>
 * Created by Roney on 2020/12/25
 */

@ConfigurationProperties(prefix = "encrypt")
@Data
@RefreshScope
public class EncryptProperties {
    private boolean enable;

    private boolean showLog = false;

    private AESConfig aesConfig;

    private DESConfig desConfig;

    private RSAConfig rsaConfig;
}
