/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.encrypt.advice;

import com.sinosoftgz.starter.encrypt.annotation.decrypt.AESDecryptBody;
import com.sinosoftgz.starter.encrypt.annotation.decrypt.DESDecryptBody;
import com.sinosoftgz.starter.encrypt.annotation.decrypt.DecryptBody;
import com.sinosoftgz.starter.encrypt.annotation.decrypt.RSADecryptBody;
import com.sinosoftgz.starter.encrypt.bean.DecryptAnnotationInfoBean;
import com.sinosoftgz.starter.encrypt.bean.DecryptHttpInputMessage;
import com.sinosoftgz.starter.encrypt.enums.DecryptBodyMethod;
import com.sinosoftgz.starter.encrypt.exception.DecryptBodyFailException;
import com.sinosoftgz.starter.encrypt.exception.DecryptMethodNotFoundException;
import com.sinosoftgz.starter.encrypt.properties.EncryptProperties;
import com.sinosoftgz.starter.encrypt.util.CheckUtils;
import com.sinosoftgz.starter.utils.lang.Lang;
import com.sinosoftgz.starter.utils.security.AESUtils;
import com.sinosoftgz.starter.utils.security.Base64Utils;
import com.sinosoftgz.starter.utils.security.DESUtils;
import com.sinosoftgz.starter.utils.security.RSAUtils;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.RequestBodyAdvice;

@Order(value=1)
@ControllerAdvice
public class DecryptRequestBodyAdvice
implements RequestBodyAdvice {
    private static final Logger log = LoggerFactory.getLogger(DecryptRequestBodyAdvice.class);
    private final EncryptProperties config;

    public boolean supports(MethodParameter methodParameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        Annotation[] annotations = methodParameter.getDeclaringClass().getAnnotations();
        if (annotations != null && annotations.length > 0) {
            for (Annotation annotation : annotations) {
                if (!(annotation instanceof DecryptBody) && !(annotation instanceof AESDecryptBody) && !(annotation instanceof DESDecryptBody) && !(annotation instanceof RSADecryptBody)) continue;
                return true;
            }
        }
        return methodParameter.getMethod().isAnnotationPresent(DecryptBody.class) || methodParameter.getMethod().isAnnotationPresent(AESDecryptBody.class) || methodParameter.getMethod().isAnnotationPresent(DESDecryptBody.class) || methodParameter.getMethod().isAnnotationPresent(RSADecryptBody.class);
    }

    public Object handleEmptyBody(Object body, HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return body;
    }

    public HttpInputMessage beforeBodyRead(HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        String body;
        try {
            body = IOUtils.toString((InputStream)inputMessage.getBody(), (String)StandardCharsets.UTF_8.name());
        }
        catch (Exception e) {
            throw new DecryptBodyFailException("Unable to get request body data, please check if the sending data body or request method is in compliance with the specification. (\u65e0\u6cd5\u83b7\u53d6\u8bf7\u6c42\u6b63\u6587\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u53d1\u9001\u6570\u636e\u4f53\u6216\u8bf7\u6c42\u65b9\u6cd5\u662f\u5426\u7b26\u5408\u89c4\u8303\u3002)");
        }
        if (body == null || Lang.isEmpty((Object)body)) {
            throw new DecryptBodyFailException("The request body is NULL or an empty string, so the decryption failed. (\u8bf7\u6c42\u6b63\u6587\u4e3aNULL\u6216\u4e3a\u7a7a\u5b57\u7b26\u4e32\uff0c\u56e0\u6b64\u89e3\u5bc6\u5931\u8d25\u3002)");
        }
        String decryptBody = null;
        DecryptAnnotationInfoBean methodAnnotation = this.getMethodAnnotation(parameter);
        if (methodAnnotation != null) {
            decryptBody = this.decryptBody(body, methodAnnotation);
        } else {
            DecryptAnnotationInfoBean classAnnotation = this.getClassAnnotation(parameter.getDeclaringClass());
            if (classAnnotation != null) {
                decryptBody = this.decryptBody(body, classAnnotation);
            }
        }
        if (decryptBody == null) {
            throw new DecryptBodyFailException("Decryption error, please check if the selected source data is encrypted correctly. (\u89e3\u5bc6\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u9009\u62e9\u7684\u6e90\u6570\u636e\u7684\u52a0\u5bc6\u65b9\u5f0f\u662f\u5426\u6b63\u786e\u3002)");
        }
        try {
            InputStream inputStream = IOUtils.toInputStream((String)decryptBody, (String)StandardCharsets.UTF_8.name());
            return new DecryptHttpInputMessage(inputStream, inputMessage.getHeaders());
        }
        catch (Exception e) {
            throw new DecryptBodyFailException("The string is converted to a stream format exception. Please check if the format such as encoding is correct. (\u5b57\u7b26\u4e32\u8f6c\u6362\u6210\u6d41\u683c\u5f0f\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u7f16\u7801\u7b49\u683c\u5f0f\u662f\u5426\u6b63\u786e\u3002)");
        }
    }

    private String decryptBody(String body, DecryptAnnotationInfoBean methodAnnotation) {
        String decryptBody = this.switchDecrypt(body, methodAnnotation);
        if (this.config.isShowLog()) {
            log.info("\u89e3\u5bc6\u524d\u7684\u6570\u636e\uff1a{}\uff0c\u89e3\u5bc6\u540e\u7684\u6570\u636e:{}", (Object)body, (Object)decryptBody);
        }
        return decryptBody;
    }

    public Object afterBodyRead(Object body, HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return body;
    }

    private DecryptAnnotationInfoBean getMethodAnnotation(MethodParameter methodParameter) {
        if (methodParameter.getMethod().isAnnotationPresent(DecryptBody.class)) {
            DecryptBody decryptBody = (DecryptBody)methodParameter.getMethodAnnotation(DecryptBody.class);
            return DecryptAnnotationInfoBean.builder().decryptBodyMethod(decryptBody.value()).key(decryptBody.otherKey()).build();
        }
        if (methodParameter.getMethod().isAnnotationPresent(DESDecryptBody.class)) {
            return DecryptAnnotationInfoBean.builder().decryptBodyMethod(DecryptBodyMethod.DES).key(((DESDecryptBody)methodParameter.getMethodAnnotation(DESDecryptBody.class)).otherKey()).build();
        }
        if (methodParameter.getMethod().isAnnotationPresent(AESDecryptBody.class)) {
            return DecryptAnnotationInfoBean.builder().decryptBodyMethod(DecryptBodyMethod.AES).key(((AESDecryptBody)methodParameter.getMethodAnnotation(AESDecryptBody.class)).otherKey()).build();
        }
        if (methodParameter.getMethod().isAnnotationPresent(RSADecryptBody.class)) {
            return DecryptAnnotationInfoBean.builder().decryptBodyMethod(DecryptBodyMethod.RSA).build();
        }
        return null;
    }

    private DecryptAnnotationInfoBean getClassAnnotation(Class<?> clazz) {
        Annotation[] annotations = clazz.getDeclaredAnnotations();
        if (annotations != null && annotations.length > 0) {
            for (Annotation annotation : annotations) {
                if (annotation instanceof DecryptBody) {
                    DecryptBody decryptBody = (DecryptBody)annotation;
                    return DecryptAnnotationInfoBean.builder().decryptBodyMethod(decryptBody.value()).key(decryptBody.otherKey()).build();
                }
                if (annotation instanceof DESDecryptBody) {
                    return DecryptAnnotationInfoBean.builder().decryptBodyMethod(DecryptBodyMethod.DES).key(((DESDecryptBody)annotation).otherKey()).build();
                }
                if (annotation instanceof AESDecryptBody) {
                    return DecryptAnnotationInfoBean.builder().decryptBodyMethod(DecryptBodyMethod.AES).key(((AESDecryptBody)annotation).otherKey()).build();
                }
                if (!(annotation instanceof RSADecryptBody)) continue;
                return DecryptAnnotationInfoBean.builder().decryptBodyMethod(DecryptBodyMethod.RSA).build();
            }
        }
        return null;
    }

    private String switchDecrypt(String formatStringBody, DecryptAnnotationInfoBean infoBean) {
        DecryptBodyMethod method = infoBean.getDecryptBodyMethod();
        if (method == null) {
            throw new DecryptMethodNotFoundException();
        }
        String key = infoBean.getKey();
        if (method == DecryptBodyMethod.DES) {
            key = CheckUtils.checkAndGetKey(this.config.getDesConfig().getKey(), key, "DES-KEY");
            return DESUtils.decrypt((String)formatStringBody, (String)key);
        }
        if (method == DecryptBodyMethod.AES) {
            key = CheckUtils.checkAndGetKey(this.config.getAesConfig().getKey(), key, "AES-KEY");
            return AESUtils.decrypt((String)formatStringBody, (String)key);
        }
        if (method == DecryptBodyMethod.RSA) {
            String[] contents;
            StringBuilder json = new StringBuilder();
            formatStringBody = formatStringBody.replaceAll(" ", "+");
            for (String value : contents = formatStringBody.split("\\|")) {
                value = new String(Objects.requireNonNull(RSAUtils.decrypt((byte[])Base64Utils.decode((String)value), (String)this.config.getRsaConfig().getPrivateKey(), (int)this.config.getRsaConfig().getMaxDecryptBlock())), StandardCharsets.UTF_8);
                json.append(value);
            }
            return json.toString();
        }
        throw new DecryptBodyFailException();
    }

    public DecryptRequestBodyAdvice(EncryptProperties config) {
        this.config = config;
    }
}

