/*
 * Decompiled with CFR 0.152.
 */
package com.sinosoftgz.starter.encrypt.advice;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sinosoftgz.starter.encrypt.annotation.encrypt.AESEncryptBody;
import com.sinosoftgz.starter.encrypt.annotation.encrypt.DESEncryptBody;
import com.sinosoftgz.starter.encrypt.annotation.encrypt.EncryptBody;
import com.sinosoftgz.starter.encrypt.annotation.encrypt.MD5EncryptBody;
import com.sinosoftgz.starter.encrypt.annotation.encrypt.RSAEncryptBody;
import com.sinosoftgz.starter.encrypt.annotation.encrypt.SHAEncryptBody;
import com.sinosoftgz.starter.encrypt.bean.EncryptAnnotationInfoBean;
import com.sinosoftgz.starter.encrypt.enums.EncryptBodyMethod;
import com.sinosoftgz.starter.encrypt.exception.EncryptBodyFailException;
import com.sinosoftgz.starter.encrypt.exception.EncryptMethodNotFoundException;
import com.sinosoftgz.starter.encrypt.properties.EncryptProperties;
import com.sinosoftgz.starter.encrypt.util.CheckUtils;
import com.sinosoftgz.starter.utils.security.AESUtils;
import com.sinosoftgz.starter.utils.security.Base64Utils;
import com.sinosoftgz.starter.utils.security.DESUtils;
import com.sinosoftgz.starter.utils.security.MD5Utils;
import com.sinosoftgz.starter.utils.security.RSAUtils;
import com.sinosoftgz.starter.utils.security.SHAUtils;
import com.sinosoftgz.starter.utils.security.enums.SHAEncryptType;
import java.lang.annotation.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.Order;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@Order(value=1)
@ControllerAdvice
public class EncryptResponseBodyAdvice
implements ResponseBodyAdvice {
    private static final Logger log = LoggerFactory.getLogger(EncryptResponseBodyAdvice.class);
    private final ObjectMapper objectMapper;
    private final EncryptProperties config;

    public boolean supports(MethodParameter returnType, Class converterType) {
        Annotation[] annotations = returnType.getDeclaringClass().getAnnotations();
        if (annotations != null && annotations.length > 0) {
            for (Annotation annotation : annotations) {
                if (!(annotation instanceof EncryptBody) && !(annotation instanceof AESEncryptBody) && !(annotation instanceof DESEncryptBody) && !(annotation instanceof RSAEncryptBody) && !(annotation instanceof MD5EncryptBody) && !(annotation instanceof SHAEncryptBody)) continue;
                return true;
            }
        }
        return returnType.getMethod().isAnnotationPresent(EncryptBody.class) || returnType.getMethod().isAnnotationPresent(AESEncryptBody.class) || returnType.getMethod().isAnnotationPresent(DESEncryptBody.class) || returnType.getMethod().isAnnotationPresent(RSAEncryptBody.class) || returnType.getMethod().isAnnotationPresent(MD5EncryptBody.class) || returnType.getMethod().isAnnotationPresent(SHAEncryptBody.class);
    }

    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        if (body == null) {
            return null;
        }
        response.getHeaders().setContentType(MediaType.TEXT_PLAIN);
        String str = null;
        try {
            str = this.objectMapper.writeValueAsString(body);
        }
        catch (JsonProcessingException e) {
            log.error("\u53d1\u751f\u5f02\u5e38:", (Throwable)e);
        }
        EncryptAnnotationInfoBean classAnnotation = this.getClassAnnotation(returnType.getDeclaringClass());
        if (classAnnotation != null) {
            return this.generatorEncrypt(str, classAnnotation);
        }
        EncryptAnnotationInfoBean methodAnnotation = this.getMethodAnnotation(returnType);
        if (methodAnnotation != null) {
            return this.generatorEncrypt(str, classAnnotation);
        }
        throw new EncryptBodyFailException();
    }

    private Object generatorEncrypt(String str, EncryptAnnotationInfoBean classAnnotation) {
        String encryptString = this.switchEncrypt(str, classAnnotation);
        if (this.config.isShowLog()) {
            log.info("\u52a0\u5bc6\u524d\u7684\u6570\u636e\uff1a{}\uff0c\u52a0\u5bc6\u540e\u7684\u6570\u636e\uff1a{}", (Object)str, (Object)encryptString);
        }
        return encryptString;
    }

    private EncryptAnnotationInfoBean getMethodAnnotation(MethodParameter methodParameter) {
        if (methodParameter.getMethod().isAnnotationPresent(EncryptBody.class)) {
            EncryptBody encryptBody = (EncryptBody)methodParameter.getMethodAnnotation(EncryptBody.class);
            return EncryptAnnotationInfoBean.builder().encryptBodyMethod(encryptBody.value()).key(encryptBody.otherKey()).shaEncryptType(encryptBody.shaType()).build();
        }
        if (methodParameter.getMethod().isAnnotationPresent(MD5EncryptBody.class)) {
            return EncryptAnnotationInfoBean.builder().encryptBodyMethod(EncryptBodyMethod.MD5).build();
        }
        if (methodParameter.getMethod().isAnnotationPresent(SHAEncryptBody.class)) {
            return EncryptAnnotationInfoBean.builder().encryptBodyMethod(EncryptBodyMethod.SHA).shaEncryptType(((SHAEncryptBody)methodParameter.getMethodAnnotation(SHAEncryptBody.class)).value()).build();
        }
        if (methodParameter.getMethod().isAnnotationPresent(DESEncryptBody.class)) {
            return EncryptAnnotationInfoBean.builder().encryptBodyMethod(EncryptBodyMethod.DES).key(((DESEncryptBody)methodParameter.getMethodAnnotation(DESEncryptBody.class)).otherKey()).build();
        }
        if (methodParameter.getMethod().isAnnotationPresent(AESEncryptBody.class)) {
            return EncryptAnnotationInfoBean.builder().encryptBodyMethod(EncryptBodyMethod.AES).key(((AESEncryptBody)methodParameter.getMethodAnnotation(AESEncryptBody.class)).otherKey()).build();
        }
        if (methodParameter.getMethod().isAnnotationPresent(RSAEncryptBody.class)) {
            return EncryptAnnotationInfoBean.builder().encryptBodyMethod(EncryptBodyMethod.RSA).build();
        }
        return null;
    }

    private EncryptAnnotationInfoBean getClassAnnotation(Class clazz) {
        Annotation[] annotations = clazz.getDeclaredAnnotations();
        if (annotations != null && annotations.length > 0) {
            for (Annotation annotation : annotations) {
                if (annotation instanceof EncryptBody) {
                    EncryptBody encryptBody = (EncryptBody)annotation;
                    return EncryptAnnotationInfoBean.builder().encryptBodyMethod(encryptBody.value()).key(encryptBody.otherKey()).shaEncryptType(encryptBody.shaType()).build();
                }
                if (annotation instanceof MD5EncryptBody) {
                    return EncryptAnnotationInfoBean.builder().encryptBodyMethod(EncryptBodyMethod.MD5).build();
                }
                if (annotation instanceof SHAEncryptBody) {
                    return EncryptAnnotationInfoBean.builder().encryptBodyMethod(EncryptBodyMethod.SHA).shaEncryptType(((SHAEncryptBody)annotation).value()).build();
                }
                if (annotation instanceof DESEncryptBody) {
                    return EncryptAnnotationInfoBean.builder().encryptBodyMethod(EncryptBodyMethod.DES).key(((DESEncryptBody)annotation).otherKey()).build();
                }
                if (annotation instanceof AESEncryptBody) {
                    return EncryptAnnotationInfoBean.builder().encryptBodyMethod(EncryptBodyMethod.AES).key(((AESEncryptBody)annotation).otherKey()).build();
                }
                if (!(annotation instanceof RSAEncryptBody)) continue;
                return EncryptAnnotationInfoBean.builder().encryptBodyMethod(EncryptBodyMethod.RSA).build();
            }
        }
        return null;
    }

    private String switchEncrypt(String formatStringBody, EncryptAnnotationInfoBean infoBean) {
        EncryptBodyMethod method = infoBean.getEncryptBodyMethod();
        if (method == null) {
            throw new EncryptMethodNotFoundException();
        }
        if (method == EncryptBodyMethod.MD5) {
            return MD5Utils.encrypt((String)formatStringBody);
        }
        if (method == EncryptBodyMethod.SHA) {
            SHAEncryptType shaEncryptType = infoBean.getShaEncryptType();
            if (shaEncryptType == null) {
                shaEncryptType = SHAEncryptType.SHA256;
            }
            return SHAUtils.encrypt((String)formatStringBody, (SHAEncryptType)shaEncryptType);
        }
        String key = infoBean.getKey();
        if (method == EncryptBodyMethod.DES) {
            key = CheckUtils.checkAndGetKey(this.config.getDesConfig().getKey(), key, "DES-KEY");
            return DESUtils.encrypt((String)formatStringBody, (String)key);
        }
        if (method == EncryptBodyMethod.AES) {
            key = CheckUtils.checkAndGetKey(this.config.getAesConfig().getKey(), key, "AES-KEY");
            return AESUtils.encrypt((String)formatStringBody, (String)key);
        }
        if (method == EncryptBodyMethod.RSA) {
            byte[] bytes = formatStringBody.getBytes();
            byte[] encodedData = RSAUtils.encrypt((byte[])bytes, (String)this.config.getRsaConfig().getPublicKey(), (int)this.config.getRsaConfig().getMaxEncryptBlock());
            return Base64Utils.encode((byte[])encodedData);
        }
        throw new EncryptBodyFailException();
    }

    public EncryptResponseBodyAdvice(ObjectMapper objectMapper, EncryptProperties config) {
        this.objectMapper = objectMapper;
        this.config = config;
    }
}

